package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.localcampaigns.CampaignManager;

/**
 * isSingleton = true
 */
public final class CampaignManagerProvider {
  @NonNull
  public static final CampaignManager get() {
    CampaignManager instance = DI.getInstance().getSingletonInstance(CampaignManager.class);
    if (instance != null) {
      return instance;
    }
    instance = CampaignManager.provide();
    DI.getInstance().addSingletonInstance(CampaignManager.class, instance);
    return instance;
  }

  @Nullable
  public static final CampaignManager getSingleton() {
    return DI.getInstance().getSingletonInstance(CampaignManager.class);
  }
}
