package com.batch.android.di.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.core.TaskExecutor;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class TaskExecutorProvider {
  @NonNull
  public static final TaskExecutor get(Context context) {
    TaskExecutor instance = DI.getInstance().getSingletonInstance(TaskExecutor.class);
    if (instance != null) {
      return instance;
    }
    instance = TaskExecutor.provide(context);
    DI.getInstance().addSingletonInstance(TaskExecutor.class, instance);
    return instance;
  }

  @Nullable
  public static final TaskExecutor getSingleton() {
    return DI.getInstance().getSingletonInstance(TaskExecutor.class);
  }
}
