/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import com.batch.android.json.JSONArray;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;

public class JSONTokener {
    private final String a;
    private int b;

    public JSONTokener(String in) {
        if (in != null && in.startsWith("\ufeff")) {
            in = in.substring(1);
        }
        this.a = in;
    }

    public Object nextValue() throws JSONException {
        int n2 = this.a();
        switch (n2) {
            case -1: {
                throw this.syntaxError("End of input");
            }
            case 123: {
                return this.e();
            }
            case 91: {
                return this.f();
            }
            case 34: 
            case 39: {
                return this.nextString((char)n2);
            }
        }
        --this.b;
        return this.d();
    }

    private int a() throws JSONException {
        block9: while (this.b < this.a.length()) {
            char c2 = this.a.charAt(this.b++);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case '/': {
                    if (this.b == this.a.length()) {
                        return c2;
                    }
                    char c3 = this.a.charAt(this.b);
                    switch (c3) {
                        case '*': {
                            ++this.b;
                            int n2 = this.a.indexOf("*/", this.b);
                            if (n2 == -1) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            this.b = n2 + 2;
                            continue block9;
                        }
                        case '/': {
                            ++this.b;
                            this.b();
                            continue block9;
                        }
                    }
                    return c2;
                }
                case '#': {
                    this.b();
                    continue block9;
                }
            }
            return c2;
        }
        return -1;
    }

    private void b() {
        while (this.b < this.a.length()) {
            char c2 = this.a.charAt(this.b);
            if (c2 == '\r' || c2 == '\n') {
                ++this.b;
                break;
            }
            ++this.b;
        }
    }

    public String nextString(char quote) throws JSONException {
        StringBuilder stringBuilder = null;
        int n2 = this.b;
        while (this.b < this.a.length()) {
            char c2;
            if ((c2 = this.a.charAt(this.b++)) == quote) {
                if (stringBuilder == null) {
                    return new String(this.a.substring(n2, this.b - 1));
                }
                stringBuilder.append(this.a, n2, this.b - 1);
                return stringBuilder.toString();
            }
            if (c2 != '\\') continue;
            if (this.b == this.a.length()) {
                throw this.syntaxError("Unterminated escape sequence");
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.a, n2, this.b - 1);
            stringBuilder.append(this.c());
            n2 = this.b;
        }
        throw this.syntaxError("Unterminated string");
    }

    private char c() throws JSONException {
        char c2 = this.a.charAt(this.b++);
        switch (c2) {
            case 'u': {
                if (this.b + 4 > this.a.length()) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String string2 = this.a.substring(this.b, this.b + 4);
                this.b += 4;
                try {
                    return (char)Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.syntaxError("Invalid escape sequence: " + string2);
                }
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return c2;
    }

    private Object d() throws JSONException {
        String string2 = this.a("{}[]/\\:,=;# \t\f");
        if (string2.length() == 0) {
            throw this.syntaxError("Expected literal value");
        }
        if ("null".equalsIgnoreCase(string2)) {
            return JSONObject.NULL;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return Boolean.FALSE;
        }
        if (string2.indexOf(46) == -1) {
            int n2 = 10;
            String string3 = string2;
            if (string3.startsWith("0x") || string3.startsWith("0X")) {
                string3 = string3.substring(2);
                n2 = 16;
            } else if (string3.startsWith("0") && string3.length() > 1) {
                string3 = string3.substring(1);
                n2 = 8;
            }
            try {
                long l2 = Long.parseLong(string3, n2);
                if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                    return (int)l2;
                }
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return new String(string2);
        }
    }

    private String a(String string2) {
        int n2 = this.b;
        while (this.b < this.a.length()) {
            char c2 = this.a.charAt(this.b);
            if (c2 == '\r' || c2 == '\n' || string2.indexOf(c2) != -1) {
                return this.a.substring(n2, this.b);
            }
            ++this.b;
        }
        return this.a.substring(n2);
    }

    private JSONObject e() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        int n2 = this.a();
        if (n2 == 125) {
            return jSONObject;
        }
        if (n2 != -1) {
            --this.b;
        }
        block4: while (true) {
            Object object;
            if (!((object = this.nextValue()) instanceof String)) {
                if (object == null) {
                    throw this.syntaxError("Names cannot be null");
                }
                throw this.syntaxError("Names must be strings, but " + object + " is of type " + object.getClass().getName());
            }
            int n3 = this.a();
            if (n3 != 58 && n3 != 61) {
                throw this.syntaxError("Expected ':' after " + object);
            }
            if (this.b < this.a.length() && this.a.charAt(this.b) == '>') {
                ++this.b;
            }
            jSONObject.put((String)object, this.nextValue());
            switch (this.a()) {
                case 125: {
                    return jSONObject;
                }
                case 44: 
                case 59: {
                    continue block4;
                }
            }
            break;
        }
        throw this.syntaxError("Unterminated object");
    }

    private JSONArray f() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        boolean bl = false;
        block9: while (true) {
            switch (this.a()) {
                case -1: {
                    throw this.syntaxError("Unterminated array");
                }
                case 93: {
                    if (bl) {
                        jSONArray.put(null);
                    }
                    return jSONArray;
                }
                case 44: 
                case 59: {
                    jSONArray.put(null);
                    bl = true;
                    continue block9;
                }
            }
            --this.b;
            jSONArray.put(this.nextValue());
            switch (this.a()) {
                case 93: {
                    return jSONArray;
                }
                case 44: 
                case 59: {
                    bl = true;
                    continue block9;
                }
            }
            break;
        }
        throw this.syntaxError("Unterminated array");
    }

    public JSONException syntaxError(String message) {
        return new JSONException(message + this);
    }

    public String toString() {
        return " at character " + this.b + " of " + this.a;
    }

    public boolean more() {
        return this.b < this.a.length();
    }

    public char next() {
        return this.b < this.a.length() ? this.a.charAt(this.b++) : (char)'\u0000';
    }

    public char next(char c2) throws JSONException {
        char c3 = this.next();
        if (c3 != c2) {
            throw this.syntaxError("Expected " + c2 + " but was " + c3);
        }
        return c3;
    }

    public char nextClean() throws JSONException {
        int n2 = this.a();
        return n2 == -1 ? (char)'\u0000' : (char)n2;
    }

    public String next(int length) throws JSONException {
        if (this.b + length > this.a.length()) {
            throw this.syntaxError(length + " is out of bounds");
        }
        String string2 = this.a.substring(this.b, this.b + length);
        this.b += length;
        return string2;
    }

    public String nextTo(String excluded) {
        if (excluded == null) {
            throw new NullPointerException("excluded == null");
        }
        return this.a(excluded).trim();
    }

    public String nextTo(char excluded) {
        return this.a(String.valueOf(excluded)).trim();
    }

    public void skipPast(String thru) {
        int n2 = this.a.indexOf(thru, this.b);
        this.b = n2 == -1 ? this.a.length() : n2 + thru.length();
    }

    public char skipTo(char to) {
        int n2 = this.a.indexOf(to, this.b);
        if (n2 != -1) {
            this.b = n2;
            return to;
        }
        return '\u0000';
    }

    public void back() {
        if (--this.b == -1) {
            this.b = 0;
        }
    }

    public static int dehexchar(char hex) {
        if (hex >= '0' && hex <= '9') {
            return hex - 48;
        }
        if (hex >= 'A' && hex <= 'F') {
            return hex - 65 + 10;
        }
        if (hex >= 'a' && hex <= 'f') {
            return hex - 97 + 10;
        }
        return -1;
    }
}

