/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import com.batch.android.json.JSONArray;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONHelper {
    private JSONHelper() {
    }

    public static Object jsonObjectToObject(Object object) throws JSONException {
        if (object instanceof JSONObject) {
            return JSONHelper.jsonObjectToMap((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return JSONHelper.jsonArrayToArray((JSONArray)object);
        }
        return object;
    }

    public static Map<String, Object> jsonObjectToMap(JSONObject object) throws JSONException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator<String> iterator = object.keys();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            hashMap.put(string2, JSONHelper.jsonObjectToObject(object.get(string2)));
        }
        return hashMap;
    }

    public static List<Object> jsonArrayToArray(JSONArray array) throws JSONException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < array.length(); ++i2) {
            arrayList.add(JSONHelper.jsonObjectToObject(array.get(i2)));
        }
        return arrayList;
    }
}

