/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.batch.android.Batch;
import com.batch.android.a.a;
import com.batch.android.c.p;
import com.batch.android.g.a.b.c;
import com.batch.android.g.e.e;
import com.batch.android.g.e.f;
import com.batch.android.g.e.j;
import com.batch.android.i.d;
import com.batch.android.i.h;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@a
public class GeofenceTransitionsIntentService
extends IntentService {
    private static final String a = "GeofenceTransitionsIS";

    public void onCreate() {
        super.onCreate();
        Batch.onServiceCreate((Context)this, false);
    }

    public void onDestroy() {
        Batch.onServiceDestroy((Context)this);
        super.onDestroy();
    }

    public GeofenceTransitionsIntentService() {
        super(a);
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        try {
            GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
            this.handleGeofencingEvent(geofencingEvent);
        }
        catch (Exception exception) {
            p.a("Could not handle geofence transition", exception);
        }
    }

    @VisibleForTesting
    public void handleGeofencingEvent(GeofencingEvent geofencingEvent) {
        if (geofencingEvent == null) {
            p.a("GeofenceTransitionIntentService triggered but did not received a geofencing event");
            return;
        }
        if (geofencingEvent.hasError()) {
            p.a(c.a(geofencingEvent.getErrorCode()));
            return;
        }
        int n2 = geofencingEvent.getGeofenceTransition();
        geofencingEvent.getGeofenceTransition();
        List list = geofencingEvent.getTriggeringGeofences();
        Map<String, Object> map = this.a(geofencingEvent);
        JSONObject jSONObject = new JSONObject(map);
        if (list != null && !list.isEmpty()) {
            Object object;
            boolean bl = false;
            HashSet<String> hashSet = new HashSet<String>(list.size());
            for (Geofence geofence : list) {
                if (!geofence.getRequestId().equals("GLOBAL_REFRESH_GEOFENCE")) {
                    String string;
                    hashSet.add(geofence.getRequestId());
                    switch (n2) {
                        case 2: {
                            string = "_GEOFENCE_EXIT";
                            break;
                        }
                        default: {
                            string = "_GEOFENCE_ENTER";
                        }
                    }
                    try {
                        jSONObject.put("id", geofence.getRequestId());
                        jSONObject.put("type", "zone");
                    }
                    catch (JSONException jSONException) {
                        p.a("Cannot put geofence id in jsonEventDatas", jSONException);
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("data", jSONObject.toString());
                    h.i().a(string.toUpperCase(Locale.US), hashMap);
                    continue;
                }
                bl = true;
            }
            if (!hashSet.isEmpty()) {
                object = n2 == 4 || n2 == 1 ? new e(hashSet, geofencingEvent.getTriggeringLocation()) : new f(hashSet, geofencingEvent.getTriggeringLocation());
                d.a().a((j)object);
            }
            if (bl) {
                object = new HashMap();
                object.put("data", jSONObject.toString());
                h.i().a("_GEOFENCE_EXIT_META".toUpperCase(Locale.US), (Map<String, Object>)object);
                com.batch.android.g.a.b.e.a().a((Context)this, geofencingEvent.getTriggeringLocation());
            }
        }
    }

    private Map<String, Object> a(GeofencingEvent geofencingEvent) {
        Location location = geofencingEvent.getTriggeringLocation();
        double d2 = Math.max(0.0, (double)location.getAccuracy());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("lat", location.getLatitude());
        hashMap.put("lng", location.getLongitude());
        hashMap.put("type", "geofence");
        hashMap.put("acc", d2);
        long l2 = location.getTime();
        if (l2 > 0L) {
            hashMap.put("date", l2);
        }
        return hashMap;
    }
}

