/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.FullColumnDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;

public class TableDefinition {
    private final String tableName;
    private final LinkedHashMap<String, FullColumnDescription> fullColumnDescriptions = new LinkedHashMap();
    private final ArrayList<FullColumnDescription> partitionKeys = new ArrayList();
    private final ArrayList<FullColumnDescription> localKeys = new ArrayList();

    public TableDefinition(String tableName, Iterable<FullColumnDescription> fullColumnDescriptions) {
        this.checkObjectInput(tableName, fullColumnDescriptions);
        this.tableName = tableName;
        for (FullColumnDescription col : fullColumnDescriptions) {
            this.fullColumnDescriptions.put(col.getName(), col);
            if (col.isPartitionKeyMember()) {
                this.partitionKeys.add(col);
            }
            if (!col.isLocalKeyMember()) continue;
            this.localKeys.add(col);
        }
        Collections.sort(this.localKeys, LocalKeyComparator.INSTANCE);
        Collections.sort(this.partitionKeys, PartitionKeyComparator.INSTANCE);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Collection<FullColumnDescription> getFullColumnDescriptions() {
        return this.fullColumnDescriptions.values();
    }

    public FullColumnDescription getDescriptionByColumnName(String columnName) {
        return this.fullColumnDescriptions.get(columnName);
    }

    public Collection<FullColumnDescription> getPartitionKeyColumnDescriptions() {
        return this.partitionKeys;
    }

    public Collection<FullColumnDescription> getLocalKeyColumnDescriptions() {
        return this.localKeys;
    }

    private void checkObjectInput(String tableName, Iterable<FullColumnDescription> fullColumnDescriptions) {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("tableName must not be null or empty.");
        }
        if (fullColumnDescriptions == null || !fullColumnDescriptions.iterator().hasNext()) {
            throw new IllegalArgumentException("fullColumnDescriptions must not be null or empty.");
        }
    }

    private static class PartitionKeyComparator
    implements Comparator<FullColumnDescription> {
        static final LocalKeyComparator INSTANCE = new LocalKeyComparator();

        private PartitionKeyComparator() {
        }

        @Override
        public int compare(FullColumnDescription o1, FullColumnDescription o2) {
            if (!o1.isPartitionKeyMember() && !o2.isPartitionKeyMember()) {
                return 0;
            }
            if (!o1.isPartitionKeyMember() && o2.isPartitionKeyMember()) {
                return 1;
            }
            if (o1.isPartitionKeyMember() && !o2.isPartitionKeyMember()) {
                return -1;
            }
            return o1.getPartitionKeyOrdinal() - o2.getPartitionKeyOrdinal();
        }
    }

    private static class LocalKeyComparator
    implements Comparator<FullColumnDescription> {
        static final LocalKeyComparator INSTANCE = new LocalKeyComparator();

        private LocalKeyComparator() {
        }

        @Override
        public int compare(FullColumnDescription o1, FullColumnDescription o2) {
            if (!o1.isLocalKeyMember() && !o2.isLocalKeyMember()) {
                return 0;
            }
            if (!o1.isLocalKeyMember() && o2.isLocalKeyMember()) {
                return 1;
            }
            if (o1.isLocalKeyMember() && !o2.isLocalKeyMember()) {
                return -1;
            }
            return o1.getLocalKeyOrdinal() - o2.getLocalKeyOrdinal();
        }
    }
}

