/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.CollectionConverters;
import com.basho.riak.client.core.query.timeseries.ColumnDescription;
import com.basho.riak.client.core.query.timeseries.ConvertibleIterator;
import com.basho.riak.client.core.query.timeseries.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;

public class QueryResult
implements Iterable<Row> {
    public static final QueryResult EMPTY = new QueryResult();
    private final Iterable<RiakTsPB.TsRow> pbRows;
    private final int pbRowsCount;
    private final List<RiakTsPB.TsColumnDescription> pbColumnDescriptions;

    private QueryResult() {
        this.pbRows = Collections.emptyList();
        this.pbRowsCount = 0;
        this.pbColumnDescriptions = Collections.emptyList();
    }

    public QueryResult(List<RiakTsPB.TsRow> tsRows) {
        this(Collections.emptyList(), tsRows);
    }

    public QueryResult(Iterable<RiakTsPB.TsRow> tsRowsIterator, int rowCount) {
        this.pbColumnDescriptions = null;
        this.pbRows = tsRowsIterator;
        this.pbRowsCount = rowCount;
    }

    public QueryResult(List<RiakTsPB.TsColumnDescription> columnsList, List<RiakTsPB.TsRow> rowsList) {
        this.pbColumnDescriptions = columnsList;
        this.pbRows = rowsList;
        this.pbRowsCount = rowsList.size();
    }

    public List<ColumnDescription> getColumnDescriptionsCopy() {
        return CollectionConverters.convertPBColumnDescriptions(this.pbColumnDescriptions);
    }

    @Override
    public Iterator<Row> iterator() {
        return ConvertibleIterator.iterateAsRow(this.pbRows.iterator());
    }

    public int getRowsCount() {
        return this.pbRowsCount;
    }

    public List<Row> getRowsCopy() {
        ArrayList<Row> rows = new ArrayList<Row>(this.getRowsCount());
        Iterator<Row> iter = this.iterator();
        while (iter.hasNext()) {
            rows.add(iter.next());
        }
        return rows;
    }
}

