/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.timeseries;

import com.basho.riak.client.core.query.timeseries.CoverageEntry;
import com.basho.riak.client.core.util.HostAndPort;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class CoveragePlanResult
implements Iterable<CoverageEntry> {
    private HashMap<HostAndPort, List<CoverageEntry>> perHostCoverage = new HashMap();

    protected CoveragePlanResult() {
    }

    protected CoveragePlanResult(CoveragePlanResult rhs) {
        this.perHostCoverage.putAll(rhs.perHostCoverage);
    }

    public Set<HostAndPort> hosts() {
        return this.perHostCoverage.keySet();
    }

    public List<CoverageEntry> hostEntries(HostAndPort host) {
        List<CoverageEntry> lst = this.perHostCoverage.get(host);
        if (lst == null) {
            return Collections.emptyList();
        }
        return lst;
    }

    public List<CoverageEntry> hostEntries(String host, int port) {
        return this.hostEntries(HostAndPort.fromParts(host, port));
    }

    private static <T> Iterator<T> emptyIterator() {
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<CoverageEntry> iterator() {
        final Iterator<List<CoverageEntry>> itor = this.perHostCoverage.values().iterator();
        return new Iterator<CoverageEntry>(){
            Iterator<CoverageEntry> subIterator = null;

            @Override
            public boolean hasNext() {
                if (this.subIterator == null || !this.subIterator.hasNext()) {
                    if (itor.hasNext()) {
                        this.subIterator = ((List)itor.next()).iterator();
                    } else {
                        this.subIterator = CoveragePlanResult.emptyIterator();
                        return false;
                    }
                }
                return this.subIterator.hasNext();
            }

            @Override
            public CoverageEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                assert (this.subIterator != null);
                return this.subIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void addEntry(CoverageEntry coverageEntry) {
        HostAndPort key = HostAndPort.fromParts(coverageEntry.getHost(), coverageEntry.getPort());
        List<CoverageEntry> lst = this.perHostCoverage.get(key);
        if (lst == null) {
            lst = new LinkedList<CoverageEntry>();
            this.perHostCoverage.put(key, lst);
        }
        lst.add(coverageEntry);
    }
}

