/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query.indexes;

import com.basho.riak.client.core.query.indexes.RiakIndex;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class RiakIndexes
implements Iterable<RiakIndex<?>> {
    private final ConcurrentHashMap<String, RiakIndex<?>> indexes = new ConcurrentHashMap();

    public int size() {
        return this.indexes.size();
    }

    public boolean isEmpty() {
        return this.indexes.isEmpty();
    }

    public <T extends RiakIndex<?>> boolean hasIndex(RiakIndex.Name<T> name) {
        return this.indexes.containsKey(name.getFullname());
    }

    public <V extends RiakIndex<?>, T extends RiakIndex.Name<V>> V getIndex(T name) {
        RiakIndex<?> existing = this.indexes.get(name.getFullname());
        if (existing != null) {
            return name.wrap(existing).createIndex();
        }
        V newIndex = name.createIndex();
        existing = this.indexes.putIfAbsent(((RiakIndex)newIndex).getFullname(), (RiakIndex<?>)newIndex);
        if (existing != null) {
            return this.getIndex(name);
        }
        return newIndex;
    }

    public <V, T extends RiakIndex<V>> T removeIndex(RiakIndex.Name<T> name) {
        RiakIndex<?> removed = this.indexes.remove(name.getFullname());
        if (removed != null) {
            T index = name.wrap(removed).createIndex();
            return index;
        }
        return null;
    }

    public void removeAllIndexes() {
        this.indexes.clear();
    }

    @Override
    public Iterator<RiakIndex<?>> iterator() {
        return this.indexes.values().iterator();
    }
}

