/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query;

import com.basho.riak.client.api.annotations.RiakVClock;
import com.basho.riak.client.api.cap.VClock;
import com.basho.riak.client.core.query.UserMetadata.RiakUserMetadata;
import com.basho.riak.client.core.query.indexes.RiakIndexes;
import com.basho.riak.client.core.query.links.RiakLinks;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.CharsetUtils;

public final class RiakObject {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private volatile BinaryValue value;
    private volatile RiakIndexes riakIndexes;
    private volatile RiakLinks links;
    private volatile RiakUserMetadata userMeta;
    private volatile String contentType = "application/octet-stream";
    private volatile String vtag;
    private volatile boolean isDeleted;
    private volatile boolean isModified;
    @RiakVClock
    private volatile VClock vclock;
    private volatile long lastModified;

    public boolean hasValue() {
        return this.value != null;
    }

    public BinaryValue getValue() {
        return this.value;
    }

    public RiakObject setValue(BinaryValue value) {
        if (value != null && value.length() == 0) {
            throw new IllegalArgumentException("value can not be zero length");
        }
        this.value = value;
        return this;
    }

    public VClock getVClock() {
        return this.vclock;
    }

    public RiakObject setVClock(VClock vclock) {
        this.vclock = vclock;
        return this;
    }

    public String getVTag() {
        return this.vtag;
    }

    public RiakObject setVTag(String vtag) {
        if (vtag != null && vtag.isEmpty()) {
            throw new IllegalArgumentException("vtag can not be zero length");
        }
        this.vtag = vtag;
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public RiakObject setLastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public RiakObject setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public boolean hasCharset() {
        return CharsetUtils.hasCharset(this.contentType);
    }

    public String getCharset() {
        return CharsetUtils.getDeclaredCharset(this.contentType);
    }

    public RiakObject setCharset(String charset) {
        this.contentType = CharsetUtils.addCharset(charset, this.contentType);
        return this;
    }

    public boolean hasIndexes() {
        return this.riakIndexes != null && !this.riakIndexes.isEmpty();
    }

    public synchronized RiakIndexes getIndexes() {
        if (null == this.riakIndexes) {
            this.riakIndexes = new RiakIndexes();
        }
        return this.riakIndexes;
    }

    public boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    public synchronized RiakLinks getLinks() {
        if (null == this.links) {
            this.links = new RiakLinks();
        }
        return this.links;
    }

    public boolean hasUserMeta() {
        return this.userMeta != null && !this.userMeta.isEmpty();
    }

    public synchronized RiakUserMetadata getUserMeta() {
        if (null == this.userMeta) {
            this.userMeta = new RiakUserMetadata();
        }
        return this.userMeta;
    }

    public RiakObject setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }
}

