/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.query;

import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import com.basho.riak.client.core.util.DefaultCharset;
import java.nio.charset.Charset;

public final class Location {
    private final Namespace namespace;
    private final BinaryValue key;

    public Location(Namespace namespace, BinaryValue key) {
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Key cannot be null or zero length");
        }
        this.namespace = namespace;
        this.key = key;
    }

    public Location(Namespace namespace, String key, Charset charset) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Key cannot be null or zero length");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset cannot be null");
        }
        this.namespace = namespace;
        this.key = BinaryValue.create(key, charset);
    }

    public Location(Namespace namespace, String key) {
        this(namespace, key, DefaultCharset.get());
    }

    public BinaryValue getKey() {
        return this.key;
    }

    public String getKeyAsString() {
        return this.key.toString();
    }

    public String getKeyAsString(Charset charset) {
        return this.key.toString(charset);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.namespace != null ? this.namespace.hashCode() : 0);
        hash = 79 * hash + (this.key != null ? this.key.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (!(this.namespace == other.namespace || this.namespace != null && this.namespace.equals(other.namespace))) {
            return false;
        }
        return this.key == other.key || this.key != null && this.key.equals(other.key);
    }

    public String toString() {
        return "{namespace: " + this.namespace + ", key: " + this.key + "}";
    }
}

