/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.PBFutureOperation;
import com.basho.riak.client.core.query.timeseries.PbResultFactory;
import com.basho.riak.client.core.query.timeseries.QueryResult;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class QueryOperation
extends PBFutureOperation<QueryResult, RiakTsPB.TsQueryResp, String> {
    private final String queryText;

    private QueryOperation(Builder builder) {
        super((byte)90, (byte)91, builder.reqBuilder, RiakTsPB.TsQueryResp.PARSER);
        this.queryText = builder.queryText;
    }

    @Override
    protected QueryResult convert(List<RiakTsPB.TsQueryResp> responses) {
        RiakTsPB.TsQueryResp response = this.checkAndGetSingleResponse(responses);
        return PbResultFactory.convertPbQueryResp(response);
    }

    @Override
    public String getQueryInfo() {
        return this.queryText;
    }

    public static class Builder {
        private final String queryText;
        private final RiakTsPB.TsQueryReq.Builder reqBuilder = RiakTsPB.TsQueryReq.newBuilder();

        public Builder(String queryText) {
            if (queryText == null || queryText.length() == 0) {
                throw new IllegalArgumentException("QueryText cannot be null or empty");
            }
            this.queryText = queryText;
            RiakTsPB.TsInterpolation.Builder interpolationBuilder = RiakTsPB.TsInterpolation.newBuilder().setBase(ByteString.copyFromUtf8(queryText));
            this.reqBuilder.setQuery(interpolationBuilder);
        }

        public Builder withCoverageContext(byte[] coverageContext) {
            if (coverageContext != null) {
                this.reqBuilder.setCoverContext(ByteString.copyFrom(coverageContext));
            }
            return this;
        }

        public QueryOperation build() {
            return new QueryOperation(this);
        }
    }
}

