/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.PBFutureOperation;
import com.basho.riak.client.core.query.timeseries.Cell;
import com.basho.riak.client.core.query.timeseries.ConvertibleIterable;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class DeleteOperation
extends PBFutureOperation<Void, RiakTsPB.TsDelResp, String> {
    private final Builder builder;
    private String queryInfoMessage;

    private DeleteOperation(Builder builder) {
        super((byte)94, (byte)95, builder.reqBuilder, RiakTsPB.TsDelResp.PARSER);
        this.builder = builder;
    }

    @Override
    protected Void convert(List<RiakTsPB.TsDelResp> responses) {
        this.checkAndGetSingleResponse(responses);
        return null;
    }

    @Override
    public String getQueryInfo() {
        if (this.queryInfoMessage == null) {
            this.queryInfoMessage = this.createQueryInfoMessage();
        }
        return this.queryInfoMessage;
    }

    private String createQueryInfoMessage() {
        StringBuilder sb = new StringBuilder();
        for (Cell cell : this.builder.keyValues) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(cell == null ? "NULL" : cell.toString());
        }
        return String.format("DELETE { %s } FROM TABLE %s", sb.toString(), this.builder.tableName);
    }

    public static class Builder {
        private final String tableName;
        private final Iterable<Cell> keyValues;
        private final RiakTsPB.TsDelReq.Builder reqBuilder = RiakTsPB.TsDelReq.newBuilder();

        public Builder(String tableName, Iterable<Cell> keyValues) {
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("Table Name cannot be null or an empty string.");
            }
            if (keyValues == null || !keyValues.iterator().hasNext()) {
                throw new IllegalArgumentException("Key Values cannot be null or an empty.");
            }
            this.reqBuilder.setTable(ByteString.copyFromUtf8(tableName));
            this.reqBuilder.addAllKey(ConvertibleIterable.asIterablePbCell(keyValues));
            this.tableName = tableName;
            this.keyValues = keyValues;
        }

        public Builder withTimeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Timeout must be positive, or 0 for no timeout.");
            }
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public DeleteOperation build() {
            return new DeleteOperation(this);
        }
    }
}

