/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations.ts;

import com.basho.riak.client.core.operations.CoveragePlanOperation;
import com.basho.riak.client.core.operations.PBFutureOperation;
import com.basho.riak.client.core.query.timeseries.CoveragePlanResult;
import com.basho.riak.client.core.query.timeseries.PbResultFactory;
import java.util.Iterator;
import java.util.List;
import shaded.com.basho.riak.protobuf.RiakTsPB;
import shaded.com.google.protobuf.ByteString;

public class CoveragePlanOperation
extends PBFutureOperation<CoveragePlanResult, RiakTsPB.TsCoverageResp, String> {
    private final String tableName;
    private final String queryText;

    private CoveragePlanOperation(AbstractBuilder builder) {
        super((byte)100, (byte)101, builder.reqBuilder, RiakTsPB.TsCoverageResp.PARSER);
        this.queryText = builder.queryText;
        this.tableName = builder.tableName;
    }

    @Override
    protected CoveragePlanResult convert(List<RiakTsPB.TsCoverageResp> responses) {
        RiakTsPB.TsCoverageResp response = this.checkAndGetSingleResponse(responses);
        return PbResultFactory.convertCoverageResp(this.tableName, response);
    }

    @Override
    public String getQueryInfo() {
        return this.queryText;
    }

    public static abstract class AbstractBuilder<R> {
        private final String tableName;
        private final String queryText;
        private final RiakTsPB.TsCoverageReq.Builder reqBuilder = RiakTsPB.TsCoverageReq.newBuilder();

        public AbstractBuilder(String tableName, String queryText) {
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("Table Name cannot be null or empty");
            }
            if (queryText == null || queryText.length() == 0) {
                throw new IllegalArgumentException("Query cannot be null or empty");
            }
            this.reqBuilder.setTable(ByteString.copyFromUtf8(tableName));
            this.reqBuilder.setQuery(RiakTsPB.TsInterpolation.newBuilder().setBase(ByteString.copyFromUtf8(queryText)));
            this.tableName = tableName;
            this.queryText = queryText;
        }

        public AbstractBuilder<R> withReplaceCoverageEntry(CoveragePlanOperation.Response.CoverageEntry coverageEntry) {
            return this.withReplaceCoverageContext(coverageEntry.getCoverageContext());
        }

        public AbstractBuilder<R> withReplaceCoverageContext(byte[] coverageContext) {
            this.reqBuilder.setReplaceCover(ByteString.copyFrom(coverageContext));
            return this;
        }

        public AbstractBuilder<R> withUnavailableCoverageContext(Iterable<byte[]> coverageContext) {
            Iterator<byte[]> iterator = coverageContext.iterator();
            while (iterator.hasNext()) {
                this.withUnavailableCoverageContext(new byte[][]{iterator.next()});
            }
            return this;
        }

        public AbstractBuilder<R> withUnavailableCoverageEntries(Iterable<CoveragePlanOperation.Response.CoverageEntry> coverageEntries) {
            for (CoveragePlanOperation.Response.CoverageEntry coverageEntry : coverageEntries) {
                this.withUnavailableCoverageContext(new byte[][]{coverageEntry.getCoverageContext()});
            }
            return this;
        }

        public AbstractBuilder<R> withUnavailableCoverageContext(byte[] ... coverageContext) {
            for (byte[] cc : coverageContext) {
                this.reqBuilder.addUnavailableCover(ByteString.copyFrom(cc));
            }
            return this;
        }

        public CoveragePlanOperation buildOperation() {
            return new CoveragePlanOperation(this);
        }

        public abstract R build();
    }
}

