/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.converters.RiakObjectConverter;
import com.basho.riak.client.core.operations.FetchOperation;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.query.RiakObject;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class StoreOperation
extends FutureOperation<Response, RiakKvPB.RpbPutResp, Location> {
    private final Logger logger = LoggerFactory.getLogger(StoreOperation.class);
    private final RiakKvPB.RpbPutReq.Builder reqBuilder;
    private final Location location;

    private StoreOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.location = builder.location;
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbPutResp> responses) {
        if (responses.size() != 1) {
            throw new IllegalStateException("RpbPutReq expects one response, " + responses.size() + " were received");
        }
        RiakKvPB.RpbPutResp response = responses.get(0);
        Response.Builder responseBuilder = new Response.Builder();
        if (response.hasKey()) {
            responseBuilder.withGeneratedKey(BinaryValue.unsafeCreate(response.getKey().toByteArray()));
        }
        if (response.getContentCount() > 0) {
            responseBuilder.addObjects(RiakObjectConverter.convert(response.getContentList(), response.getVclock()));
        }
        return responseBuilder.build();
    }

    @Override
    protected RiakKvPB.RpbPutResp decode(RiakMessage rawMessage) {
        Operations.checkMessageType(rawMessage, (byte)12);
        try {
            return RiakKvPB.RpbPutResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.error("Invalid message received; {}", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected RiakMessage createChannelMessage() {
        RiakKvPB.RpbPutReq req = this.reqBuilder.build();
        return new RiakMessage(11, req.toByteArray());
    }

    @Override
    public Location getQueryInfo() {
        return this.location;
    }

    public static class Response
    extends FetchOperation.KvResponseBase {
        private final BinaryValue generatedKey;

        private Response(Init<?> builder) {
            super(builder);
            this.generatedKey = ((Init)builder).generatedKey;
        }

        public boolean hasGeneratedKey() {
            return this.generatedKey != null;
        }

        public BinaryValue getGeneratedKey() {
            return this.generatedKey;
        }

        static class Builder
        extends Init<Builder> {
            Builder() {
            }

            @Override
            protected Builder self() {
                return this;
            }

            @Override
            protected Response build() {
                return new Response(this);
            }
        }

        protected static abstract class Init<T extends Init<T>>
        extends FetchOperation.KvResponseBase.Init<T> {
            private BinaryValue generatedKey;

            protected Init() {
            }

            T withGeneratedKey(BinaryValue key) {
                this.generatedKey = key;
                return (T)((Init)this.self());
            }
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbPutReq.Builder reqBuilder = RiakKvPB.RpbPutReq.newBuilder();
        private final Location location;

        public Builder(Location location) {
            if (location == null) {
                throw new IllegalArgumentException("Location cannot be null");
            }
            this.reqBuilder.setType(ByteString.copyFrom(location.getNamespace().getBucketType().unsafeGetValue()));
            this.reqBuilder.setBucket(ByteString.copyFrom(location.getNamespace().getBucketName().unsafeGetValue()));
            this.reqBuilder.setKey(ByteString.copyFrom(location.getKey().unsafeGetValue()));
            this.location = location;
        }

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            this.reqBuilder.setType(ByteString.copyFrom(namespace.getBucketType().unsafeGetValue()));
            this.reqBuilder.setBucket(ByteString.copyFrom(namespace.getBucketName().unsafeGetValue()));
            this.location = new Location(namespace, "RIAK_GENERATED");
        }

        public Builder withContent(RiakObject content) {
            if (null == content) {
                throw new IllegalArgumentException("Object cannot be null.");
            }
            this.reqBuilder.setContent(RiakObjectConverter.convert(content));
            if (content.getVClock() != null) {
                this.reqBuilder.setVclock(ByteString.copyFrom(content.getVClock().getBytes()));
            }
            return this;
        }

        public Builder withW(int w) {
            this.reqBuilder.setW(w);
            return this;
        }

        public Builder withDw(int dw) {
            this.reqBuilder.setDw(dw);
            return this;
        }

        public Builder withPw(int pw) {
            this.reqBuilder.setPw(pw);
            return this;
        }

        public Builder withReturnBody(boolean returnBody) {
            this.reqBuilder.setReturnBody(returnBody);
            return this;
        }

        public Builder withReturnHead(boolean returnHead) {
            this.reqBuilder.setReturnHead(returnHead);
            return this;
        }

        public Builder withIfNotModified(boolean ifNotModified) {
            this.reqBuilder.setIfNotModified(ifNotModified);
            return this;
        }

        public Builder withIfNoneMatch(boolean ifNoneMatch) {
            this.reqBuilder.setIfNoneMatch(ifNoneMatch);
            return this;
        }

        public Builder withAsis(boolean asis) {
            this.reqBuilder.setAsis(asis);
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.reqBuilder.setTimeout(timeout);
            return this;
        }

        public Builder withNVal(int nval) {
            this.reqBuilder.setNVal(nval);
            return this;
        }

        public Builder withSloppyQuorum(boolean sloppyQuorum) {
            this.reqBuilder.setSloppyQuorum(sloppyQuorum);
            return this;
        }

        public StoreOperation build() {
            return new StoreOperation(this);
        }
    }
}

