/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.operations;

import com.basho.riak.client.core.FutureOperation;
import com.basho.riak.client.core.RiakMessage;
import com.basho.riak.client.core.operations.Operations;
import com.basho.riak.client.core.util.BinaryValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.basho.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;
import shaded.com.google.protobuf.InvalidProtocolBufferException;

public class MapReduceOperation
extends FutureOperation<Response, RiakKvPB.RpbMapRedResp, BinaryValue> {
    private final RiakKvPB.RpbMapRedReq.Builder reqBuilder;
    private final BinaryValue mapReduce;
    private final Logger logger = LoggerFactory.getLogger(MapReduceOperation.class);

    private MapReduceOperation(Builder builder) {
        this.reqBuilder = builder.reqBuilder;
        this.mapReduce = builder.mapReduce;
    }

    @Override
    protected Response convert(List<RiakKvPB.RpbMapRedResp> rawResponse) {
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ObjectMapper mapper = new ObjectMapper();
        LinkedHashMap<Integer, ArrayNode> resultMap = new LinkedHashMap<Integer, ArrayNode>();
        int phase = 0;
        for (RiakKvPB.RpbMapRedResp response : rawResponse) {
            JsonNode responseJson;
            ArrayNode jsonArray;
            if (response.hasPhase()) {
                phase = response.getPhase();
            }
            if (!response.hasResponse()) continue;
            if (resultMap.containsKey(phase)) {
                jsonArray = (ArrayNode)resultMap.get(phase);
            } else {
                jsonArray = factory.arrayNode();
                resultMap.put(phase, jsonArray);
            }
            try {
                responseJson = mapper.readTree(response.getResponse().toStringUtf8());
            }
            catch (IOException ex) {
                this.logger.error("Mapreduce job returned non-JSON; {}", (Object)response.getResponse().toStringUtf8());
                throw new RuntimeException("Non-JSON response from MR job", ex);
            }
            if (responseJson.isArray()) {
                jsonArray.addAll((ArrayNode)responseJson);
                continue;
            }
            this.logger.error("Mapreduce job returned JSON that wasn't an array; {}", (Object)response.getResponse().toStringUtf8());
        }
        return new Response(resultMap);
    }

    @Override
    protected RiakMessage createChannelMessage() {
        RiakKvPB.RpbMapRedReq request = this.reqBuilder.build();
        return new RiakMessage(23, request.toByteArray());
    }

    @Override
    protected RiakKvPB.RpbMapRedResp decode(RiakMessage rawMessage) {
        Operations.checkMessageType(rawMessage, (byte)24);
        try {
            return RiakKvPB.RpbMapRedResp.parseFrom(rawMessage.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected boolean done(RiakKvPB.RpbMapRedResp message) {
        return message.getDone();
    }

    @Override
    public BinaryValue getQueryInfo() {
        return this.mapReduce;
    }

    public static class Response {
        private final Map<Integer, ArrayNode> resultMap;

        Response(Map<Integer, ArrayNode> results) {
            this.resultMap = results;
        }

        public Map<Integer, ArrayNode> getResults() {
            return this.resultMap;
        }
    }

    public static class Builder {
        private final RiakKvPB.RpbMapRedReq.Builder reqBuilder = RiakKvPB.RpbMapRedReq.newBuilder();
        private final BinaryValue mapReduce;

        public Builder(BinaryValue mapReduce) {
            if (null == mapReduce || mapReduce.length() == 0) {
                throw new IllegalArgumentException("MapReduce can not be null or empty.");
            }
            this.reqBuilder.setRequest(ByteString.copyFrom(mapReduce.unsafeGetValue())).setContentType(ByteString.copyFromUtf8("application/json"));
            this.mapReduce = mapReduce;
        }

        public MapReduceOperation build() {
            return new MapReduceOperation(this);
        }
    }
}

