/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.core.netty;

import com.basho.riak.client.core.RiakMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;

public class RiakMessageCodec
extends ByteToMessageCodec<RiakMessage> {
    protected void encode(ChannelHandlerContext ctx, RiakMessage msg, ByteBuf out) throws Exception {
        int length = msg.getData().length + 1;
        out.writeInt(length);
        out.writeByte((int)msg.getCode());
        out.writeBytes(msg.getData());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() >= 4) {
            in.markReaderIndex();
            int length = in.readInt();
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return;
            }
            byte code = in.readByte();
            byte[] array = new byte[length - 1];
            in.readBytes(array);
            out.add(new RiakMessage(code, array));
        }
    }
}

