/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert.reflection;

import com.basho.riak.client.api.annotations.RiakUsermeta;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class UsermetaField {
    private final Field field;
    private final String usermetaDataKey;
    private final FieldType fieldType;

    public UsermetaField(Field field) {
        this.fieldType = this.validateAndGetType(field);
        this.field = field;
        this.usermetaDataKey = field.getAnnotation(RiakUsermeta.class).key();
        if (this.fieldType == FieldType.STRING && "".equals(this.usermetaDataKey)) {
            throw new IllegalArgumentException("@RiakUsermeta annotated String must include key: " + field);
        }
    }

    public Field getField() {
        return this.field;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public String getUsermetaDataKey() {
        return this.usermetaDataKey;
    }

    private FieldType validateAndGetType(Field f) {
        if (f != null) {
            Type t = f.getGenericType();
            if (t instanceof ParameterizedType) {
                Type[] genericTypes;
                ParameterizedType pType = (ParameterizedType)t;
                if (pType.getRawType().equals(Map.class) && String.class.equals((Object)(genericTypes = pType.getActualTypeArguments())[0]) && String.class.equals((Object)genericTypes[1])) {
                    return FieldType.MAP;
                }
            } else if (f.getType().equals(String.class)) {
                return FieldType.STRING;
            }
            throw new IllegalArgumentException("@RiakUsermeta must be a Map<String,String> or single String: " + f);
        }
        throw new IllegalArgumentException("Field can not be null.");
    }

    public static enum FieldType {
        STRING,
        MAP;

    }
}

