/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert.reflection;

import com.basho.riak.client.api.annotations.RiakIndex;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Set;

public class RiakIndexField {
    private final Field field;
    private final String indexName;
    private final FieldType type;

    public RiakIndexField(Field field) {
        this.type = this.validateAndGetType(field);
        this.field = field;
        this.indexName = field.getAnnotation(RiakIndex.class).name();
        if (this.indexName.isEmpty()) {
            throw new IllegalArgumentException("@RiakIndex must have 'name' parameter");
        }
        if (!(this.type != FieldType.RAW && this.type != FieldType.SET_RAW || this.indexName.endsWith("_int") || this.indexName.endsWith("_bin"))) {
            throw new IllegalArgumentException("@RiakIndex annotated byte[] must declare full indexname");
        }
    }

    public Field getField() {
        return this.field;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public FieldType getFieldType() {
        return this.type;
    }

    private FieldType validateAndGetType(Field f) {
        if (f != null) {
            Type t = f.getGenericType();
            if (t instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)t;
                if (pType.getRawType().equals(Set.class)) {
                    Class genericType = (Class)pType.getActualTypeArguments()[0];
                    if (String.class.equals((Object)genericType)) {
                        return FieldType.SET_STRING;
                    }
                    if (Long.class.equals((Object)genericType)) {
                        return FieldType.SET_LONG;
                    }
                    if (BigInteger.class.equals((Object)genericType)) {
                        return FieldType.SET_BIG_INT;
                    }
                    if (genericType.isArray() && genericType.getComponentType().equals(Byte.TYPE)) {
                        return FieldType.SET_RAW;
                    }
                }
            } else {
                Class<?> c = f.getType();
                if (c.equals(String.class)) {
                    return FieldType.STRING;
                }
                if (c.equals(Long.class) || c.equals(Long.TYPE)) {
                    return FieldType.LONG;
                }
                if (c.equals(BigInteger.class)) {
                    return FieldType.BIG_INT;
                }
                if (c.isArray() && c.getComponentType().equals(Byte.TYPE)) {
                    return FieldType.RAW;
                }
            }
            throw new IllegalArgumentException("@RiakIndex must be a single or Set<> of Long, BigInteger, or String: " + f);
        }
        throw new IllegalArgumentException("Field can not be null.");
    }

    public static enum FieldType {
        LONG,
        SET_LONG,
        STRING,
        SET_STRING,
        RAW,
        SET_RAW,
        BIG_INT,
        SET_BIG_INT;

    }
}

