/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.convert;

import com.basho.riak.client.api.convert.ConversionException;
import com.basho.riak.client.api.convert.Converter;
import com.basho.riak.client.api.convert.RiakJacksonModule;
import com.basho.riak.client.core.util.BinaryValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class JSONConverter<T>
extends Converter<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final TypeReference<T> typeReference;

    public JSONConverter(Type type) {
        super(type);
        this.typeReference = null;
    }

    public JSONConverter(TypeReference<T> typeReference) {
        super(typeReference.getType());
        this.typeReference = typeReference;
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static void registerJacksonModule(Module jacksonModule) {
        OBJECT_MAPPER.registerModule(jacksonModule);
    }

    @Override
    public T toDomain(BinaryValue value, String contentType) {
        try {
            if (this.typeReference != null) {
                return (T)OBJECT_MAPPER.readValue(value.unsafeGetValue(), this.typeReference);
            }
            Class rawType = this.type instanceof Class ? (Class)this.type : (Class)((ParameterizedType)this.type).getRawType();
            return (T)OBJECT_MAPPER.readValue(value.unsafeGetValue(), rawType);
        }
        catch (IOException ex) {
            throw new ConversionException(ex);
        }
    }

    @Override
    public Converter.ContentAndType fromDomain(T domainObject) {
        try {
            return new Converter.ContentAndType(this, BinaryValue.unsafeCreate(OBJECT_MAPPER.writeValueAsBytes(domainObject)), "application/json");
        }
        catch (JsonProcessingException ex) {
            throw new ConversionException(ex);
        }
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new RiakJacksonModule());
        OBJECT_MAPPER.registerModule((Module)new JodaModule());
    }
}

