/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.timeseries;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.operations.ts.StoreOperation;
import com.basho.riak.client.core.query.timeseries.Row;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Store
extends RiakCommand<Void, String> {
    private final Builder builder;

    private Store(Builder builder) {
        this.builder = builder;
    }

    @Override
    protected RiakFuture<Void, String> executeAsync(RiakCluster cluster) {
        RiakFuture<Void, String> future = cluster.execute(this.buildCoreOperation());
        return future;
    }

    private StoreOperation buildCoreOperation() {
        return new StoreOperation.Builder(this.builder.tableName).withRows(this.builder.rows).build();
    }

    public static class Builder {
        private final String tableName;
        private final List<Row> rows = new LinkedList<Row>();

        public Builder(String tableName) {
            this.tableName = tableName;
        }

        public Builder withRow(Row row) {
            this.rows.add(row);
            return this;
        }

        public Builder withRows(Iterable<Row> rows) {
            if (rows instanceof Collection) {
                this.rows.addAll((Collection)rows);
            } else {
                for (Row r : rows) {
                    this.rows.add(r);
                }
            }
            return this;
        }

        public Store build() {
            return new Store(this);
        }
    }
}

