/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.api.commands.kv;

import com.basho.riak.client.api.RiakCommand;
import com.basho.riak.client.api.commands.CoreFutureAdapter;
import com.basho.riak.client.core.RiakCluster;
import com.basho.riak.client.core.RiakFuture;
import com.basho.riak.client.core.RiakFutureListener;
import com.basho.riak.client.core.operations.ListKeysOperation;
import com.basho.riak.client.core.query.Location;
import com.basho.riak.client.core.query.Namespace;
import com.basho.riak.client.core.util.BinaryValue;
import java.util.Iterator;
import java.util.List;

public final class ListKeys
extends RiakCommand<Response, Namespace> {
    private final Namespace namespace;
    private final int timeout;

    ListKeys(Builder builder) {
        this.namespace = builder.namespace;
        this.timeout = builder.timeout;
    }

    @Override
    protected final RiakFuture<Response, Namespace> executeAsync(RiakCluster cluster) {
        RiakFuture<ListKeysOperation.Response, Namespace> coreFuture = cluster.execute(this.buildCoreOperation());
        CoreFutureAdapter<Response, Namespace, ListKeysOperation.Response, Namespace> future = new CoreFutureAdapter<Response, Namespace, ListKeysOperation.Response, Namespace>(coreFuture){

            @Override
            protected Response convertResponse(ListKeysOperation.Response coreResponse) {
                return new Response(ListKeys.this.namespace, coreResponse.getKeys());
            }

            @Override
            protected Namespace convertQueryInfo(Namespace coreQueryInfo) {
                return coreQueryInfo;
            }
        };
        coreFuture.addListener((RiakFutureListener<ListKeysOperation.Response, Namespace>)future);
        return future;
    }

    private ListKeysOperation buildCoreOperation() {
        ListKeysOperation.Builder builder = new ListKeysOperation.Builder(this.namespace);
        if (this.timeout > 0) {
            builder.withTimeout(this.timeout);
        }
        return builder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeys)) {
            return false;
        }
        ListKeys other = (ListKeys)obj;
        if (!(this.namespace == other.namespace || this.namespace != null && this.namespace.equals(other.namespace))) {
            return false;
        }
        return this.timeout == other.timeout;
    }

    public String toString() {
        return String.format("{namespace: %s, timeout: %s}", this.namespace, this.timeout);
    }

    public static class Builder {
        private final Namespace namespace;
        private int timeout;

        public Builder(Namespace namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace cannot be null");
            }
            this.namespace = namespace;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ListKeys build() {
            return new ListKeys(this);
        }
    }

    private static class Itr
    implements Iterator<Location> {
        private final Iterator<BinaryValue> iterator;
        private final Namespace namespace;

        private Itr(Namespace namespace, Iterator<BinaryValue> iterator) {
            this.iterator = iterator;
            this.namespace = namespace;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Location next() {
            BinaryValue key = this.iterator.next();
            return new Location(this.namespace, key);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    public static class Response
    implements Iterable<Location> {
        private final Namespace namespace;
        private final List<BinaryValue> keys;

        public Response(Namespace namespace, List<BinaryValue> keys) {
            this.namespace = namespace;
            this.keys = keys;
        }

        @Override
        public Iterator<Location> iterator() {
            return new Itr(this.namespace, this.keys.iterator());
        }
    }
}

