/*
 * Decompiled with CFR 0.152.
 */
package com.basgeekball.awesomevalidation.model;

import android.support.annotation.Nullable;
import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class NumericRange {
    private Range mRange;

    public NumericRange(Range range) {
        this.mRange = range;
    }

    private static boolean isNumberFormat(String string) {
        return Pattern.compile("^-?(([1-9]\\d*(\\.\\d+)?)||(0\\.\\d+)||0)$").matcher(string).find();
    }

    public boolean isValid(String string) {
        BigDecimal bigDecimal;
        if (!NumericRange.isNumberFormat(string)) {
            return false;
        }
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (Exception exception) {
            return false;
        }
        Boolean bl = this.isInteger(bigDecimal);
        if (bl != null) {
            return bl;
        }
        Boolean bl2 = this.isDecimal(bigDecimal);
        if (bl2 != null) {
            return bl2;
        }
        return false;
    }

    @Nullable
    private Boolean isInteger(BigDecimal bigDecimal) {
        if (bigDecimal.scale() == 0) {
            try {
                return this.mRange.contains((Comparable)Integer.valueOf(bigDecimal.intValueExact()));
            }
            catch (Exception exception) {
                try {
                    return this.mRange.contains((Comparable)Long.valueOf(bigDecimal.longValueExact()));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    private Boolean isDecimal(BigDecimal bigDecimal) {
        try {
            return this.mRange.contains((Comparable)Float.valueOf(bigDecimal.floatValue()));
        }
        catch (Exception exception) {
            try {
                return this.mRange.contains((Comparable)Double.valueOf(bigDecimal.doubleValue()));
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }
}

