/*
 * Decompiled with CFR 0.152.
 */
package com.basgeekball.awesomevalidation;

import android.support.design.widget.TextInputLayout;
import android.view.View;
import android.widget.EditText;
import com.basgeekball.awesomevalidation.exception.BadLayoutException;
import com.basgeekball.awesomevalidation.model.NumericRange;
import com.basgeekball.awesomevalidation.utility.custom.CustomErrorReset;
import com.basgeekball.awesomevalidation.utility.custom.CustomValidation;
import com.basgeekball.awesomevalidation.utility.custom.CustomValidationCallback;
import com.basgeekball.awesomevalidation.utility.custom.SimpleCustomValidation;
import java.util.regex.Pattern;

public class ValidationHolder {
    private EditText mEditText;
    private EditText mConfirmationEditText;
    private TextInputLayout mTextInputLayout;
    private TextInputLayout mConfirmationTextInputLayout;
    private View mView;
    private Pattern mPattern;
    private NumericRange mNumericRange;
    private String mErrMsg;
    private SimpleCustomValidation mSimpleCustomValidation;
    private CustomValidation mCustomValidation;
    private CustomValidationCallback mCustomValidationCallback;
    private CustomErrorReset mCustomErrorReset;

    public ValidationHolder(EditText editText, Pattern pattern, String string) {
        this.mEditText = editText;
        this.mPattern = pattern;
        this.mErrMsg = string;
    }

    public ValidationHolder(EditText editText, NumericRange numericRange, String string) {
        this.mEditText = editText;
        this.mNumericRange = numericRange;
        this.mErrMsg = string;
    }

    public ValidationHolder(EditText editText, EditText editText2, String string) {
        this.mConfirmationEditText = editText;
        this.mEditText = editText2;
        this.mErrMsg = string;
    }

    public ValidationHolder(EditText editText, SimpleCustomValidation simpleCustomValidation, String string) {
        this.mEditText = editText;
        this.mSimpleCustomValidation = simpleCustomValidation;
        this.mErrMsg = string;
    }

    public ValidationHolder(TextInputLayout textInputLayout, Pattern pattern, String string) {
        this.mTextInputLayout = textInputLayout;
        this.mPattern = pattern;
        this.mErrMsg = string;
    }

    public ValidationHolder(TextInputLayout textInputLayout, NumericRange numericRange, String string) {
        this.mTextInputLayout = textInputLayout;
        this.mNumericRange = numericRange;
        this.mErrMsg = string;
    }

    public ValidationHolder(TextInputLayout textInputLayout, TextInputLayout textInputLayout2, String string) {
        this.mConfirmationTextInputLayout = textInputLayout;
        this.mTextInputLayout = textInputLayout2;
        this.mErrMsg = string;
    }

    public ValidationHolder(TextInputLayout textInputLayout, SimpleCustomValidation simpleCustomValidation, String string) {
        this.mTextInputLayout = textInputLayout;
        this.mSimpleCustomValidation = simpleCustomValidation;
        this.mErrMsg = string;
    }

    public ValidationHolder(View view, CustomValidation customValidation, CustomValidationCallback customValidationCallback, CustomErrorReset customErrorReset, String string) {
        this.mView = view;
        this.mCustomValidation = customValidation;
        this.mCustomValidationCallback = customValidationCallback;
        this.mCustomErrorReset = customErrorReset;
        this.mErrMsg = string;
    }

    public boolean isRegexType() {
        return this.mPattern != null;
    }

    public boolean isRangeType() {
        return this.mNumericRange != null;
    }

    public boolean isConfirmationType() {
        return this.mConfirmationEditText != null || this.mConfirmationTextInputLayout != null;
    }

    public boolean isSimpleCustomType() {
        return this.mSimpleCustomValidation != null;
    }

    public boolean isCustomType() {
        return this.mCustomValidation != null;
    }

    public boolean isEditTextView() {
        return this.mEditText != null;
    }

    public boolean isTextInputLayoutView() {
        return this.mTextInputLayout != null;
    }

    public boolean isSomeSortOfView() {
        return this.mView != null;
    }

    public Pattern getPattern() {
        return this.mPattern;
    }

    public NumericRange getNumericRange() {
        return this.mNumericRange;
    }

    public SimpleCustomValidation getSimpleCustomValidation() {
        return this.mSimpleCustomValidation;
    }

    public CustomValidation getCustomValidation() {
        return this.mCustomValidation;
    }

    public CustomValidationCallback getCustomValidationCallback() {
        return this.mCustomValidationCallback;
    }

    public String getErrMsg() {
        return this.mErrMsg;
    }

    public String getText() {
        if (this.mEditText != null) {
            return this.mEditText.getText().toString();
        }
        if (this.mTextInputLayout != null) {
            EditText editText = this.mTextInputLayout.getEditText();
            if (editText != null) {
                return editText.getText().toString();
            }
            throw new BadLayoutException("EditText must be present inside TextInputLayout.");
        }
        return null;
    }

    public String getConfirmationText() {
        if (this.mConfirmationEditText != null) {
            return this.mConfirmationEditText.getText().toString();
        }
        if (this.mConfirmationTextInputLayout != null) {
            EditText editText = this.mConfirmationTextInputLayout.getEditText();
            if (editText != null) {
                return editText.getText().toString();
            }
            throw new BadLayoutException("EditText must be present inside TextInputLayout.");
        }
        return null;
    }

    public EditText getEditText() {
        if (this.isEditTextView()) {
            return this.isConfirmationType() ? this.mConfirmationEditText : this.mEditText;
        }
        if (this.isTextInputLayoutView()) {
            return this.isConfirmationType() ? this.mConfirmationTextInputLayout.getEditText() : this.mTextInputLayout.getEditText();
        }
        return null;
    }

    public TextInputLayout getTextInputLayout() {
        if (this.isTextInputLayoutView()) {
            return this.isConfirmationType() ? this.mConfirmationTextInputLayout : this.mTextInputLayout;
        }
        return null;
    }

    public View getView() {
        if (this.isSomeSortOfView()) {
            return this.mView;
        }
        return null;
    }

    public boolean isVisible() {
        return this.isEditTextView() && this.getEditText().getVisibility() == 0 || this.isTextInputLayoutView() && this.getTextInputLayout().getVisibility() == 0 || this.isSomeSortOfView() && this.getView().getVisibility() == 0;
    }

    public void resetCustomError() {
        this.mCustomErrorReset.reset(this);
    }
}

