/*
 * Decompiled with CFR 0.152.
 */
package com.basgeekball.awesomevalidation;

import android.app.Activity;
import android.content.Context;
import android.support.design.widget.TextInputLayout;
import android.view.View;
import android.widget.EditText;
import com.basgeekball.awesomevalidation.ValidationStyle;
import com.basgeekball.awesomevalidation.model.NumericRange;
import com.basgeekball.awesomevalidation.utility.custom.CustomErrorReset;
import com.basgeekball.awesomevalidation.utility.custom.CustomValidation;
import com.basgeekball.awesomevalidation.utility.custom.CustomValidationCallback;
import com.basgeekball.awesomevalidation.utility.custom.SimpleCustomValidation;
import com.basgeekball.awesomevalidation.validators.BasicValidator;
import com.basgeekball.awesomevalidation.validators.ColorationValidator;
import com.basgeekball.awesomevalidation.validators.TextInputLayoutValidator;
import com.basgeekball.awesomevalidation.validators.UnderlabelValidator;
import com.basgeekball.awesomevalidation.validators.Validator;
import com.google.common.collect.Range;
import java.util.regex.Pattern;

public class AwesomeValidation {
    private Validator mValidator = null;
    private static boolean autoFocusOnFirstFailure = true;

    public AwesomeValidation(ValidationStyle validationStyle) {
        switch (validationStyle) {
            case BASIC: {
                if (this.mValidator == null || !(this.mValidator instanceof BasicValidator)) {
                    this.mValidator = new BasicValidator();
                }
                return;
            }
            case COLORATION: {
                if (this.mValidator == null || !(this.mValidator instanceof ColorationValidator)) {
                    this.mValidator = new ColorationValidator();
                }
                return;
            }
            case UNDERLABEL: {
                if (this.mValidator == null || !(this.mValidator instanceof UnderlabelValidator)) {
                    this.mValidator = new UnderlabelValidator();
                }
                return;
            }
            case TEXT_INPUT_LAYOUT: {
                if (this.mValidator == null || !(this.mValidator instanceof TextInputLayoutValidator)) {
                    this.mValidator = new TextInputLayoutValidator();
                }
                return;
            }
        }
    }

    public static boolean isAutoFocusOnFirstFailureEnabled() {
        return autoFocusOnFirstFailure;
    }

    public static void disableAutoFocusOnFirstFailure() {
        autoFocusOnFirstFailure = false;
    }

    private void checkIsColorationValidator() {
        if (!(this.mValidator instanceof ColorationValidator)) {
            throw new UnsupportedOperationException("Only supported by ColorationValidator.");
        }
    }

    private void checkIsUnderlabelValidator() {
        if (!(this.mValidator instanceof UnderlabelValidator)) {
            throw new UnsupportedOperationException("Only supported by UnderlabelValidator.");
        }
    }

    private void checkIsTextInputLayoutValidator() {
        if (!(this.mValidator instanceof TextInputLayoutValidator)) {
            throw new UnsupportedOperationException("Only supported by TextInputLayoutValidator.");
        }
    }

    private void checkIsNotTextInputLayoutValidator() {
        if (this.mValidator instanceof TextInputLayoutValidator) {
            throw new UnsupportedOperationException("Not supported by TextInputLayoutValidator.");
        }
    }

    public void setContext(Context context) {
        this.checkIsUnderlabelValidator();
        ((UnderlabelValidator)this.mValidator).setContext(context);
    }

    public void setColor(int n) {
        this.checkIsColorationValidator();
        ((ColorationValidator)this.mValidator).setColor(n);
    }

    public void setUnderlabelColor(int n) {
        this.checkIsUnderlabelValidator();
        ((UnderlabelValidator)this.mValidator).setColor(n);
    }

    public void setUnderlabelColorByResource(int n) {
        this.checkIsUnderlabelValidator();
        ((UnderlabelValidator)this.mValidator).setColorByResource(n);
    }

    public void addValidation(EditText editText, String string, String string2) {
        this.checkIsNotTextInputLayoutValidator();
        this.mValidator.set(editText, string, string2);
    }

    public void addValidation(TextInputLayout textInputLayout, String string, String string2) {
        this.checkIsTextInputLayoutValidator();
        this.mValidator.set(textInputLayout, string, string2);
    }

    public void addValidation(Activity activity, int n, String string, int n2) {
        this.mValidator.set(activity, n, string, n2);
    }

    public void addValidation(EditText editText, Pattern pattern, String string) {
        this.checkIsNotTextInputLayoutValidator();
        this.mValidator.set(editText, pattern, string);
    }

    public void addValidation(TextInputLayout textInputLayout, Pattern pattern, String string) {
        this.checkIsTextInputLayoutValidator();
        this.mValidator.set(textInputLayout, pattern, string);
    }

    public void addValidation(Activity activity, int n, Pattern pattern, int n2) {
        this.mValidator.set(activity, n, pattern, n2);
    }

    public void addValidation(EditText editText, Range range, String string) {
        this.checkIsNotTextInputLayoutValidator();
        this.mValidator.set(editText, new NumericRange(range), string);
    }

    public void addValidation(TextInputLayout textInputLayout, Range range, String string) {
        this.checkIsTextInputLayoutValidator();
        this.mValidator.set(textInputLayout, new NumericRange(range), string);
    }

    public void addValidation(Activity activity, int n, Range range, int n2) {
        this.mValidator.set(activity, n, new NumericRange(range), n2);
    }

    public void addValidation(EditText editText, EditText editText2, String string) {
        this.checkIsNotTextInputLayoutValidator();
        this.mValidator.set(editText, editText2, string);
    }

    public void addValidation(TextInputLayout textInputLayout, TextInputLayout textInputLayout2, String string) {
        this.checkIsTextInputLayoutValidator();
        this.mValidator.set(textInputLayout, textInputLayout2, string);
    }

    public void addValidation(Activity activity, int n, int n2, int n3) {
        this.mValidator.set(activity, n, n2, n3);
    }

    public void addValidation(EditText editText, SimpleCustomValidation simpleCustomValidation, String string) {
        this.checkIsNotTextInputLayoutValidator();
        this.mValidator.set(editText, simpleCustomValidation, string);
    }

    public void addValidation(TextInputLayout textInputLayout, SimpleCustomValidation simpleCustomValidation, String string) {
        this.checkIsTextInputLayoutValidator();
        this.mValidator.set(textInputLayout, simpleCustomValidation, string);
    }

    public void addValidation(Activity activity, int n, SimpleCustomValidation simpleCustomValidation, int n2) {
        this.mValidator.set(activity, n, simpleCustomValidation, n2);
    }

    public void addValidation(View view, CustomValidation customValidation, CustomValidationCallback customValidationCallback, CustomErrorReset customErrorReset, String string) {
        this.mValidator.set(view, customValidation, customValidationCallback, customErrorReset, string);
    }

    public void addValidation(Activity activity, int n, CustomValidation customValidation, CustomValidationCallback customValidationCallback, CustomErrorReset customErrorReset, int n2) {
        this.mValidator.set(activity, n, customValidation, customValidationCallback, customErrorReset, n2);
    }

    public boolean validate() {
        return this.mValidator.trigger();
    }

    public void clear() {
        this.mValidator.halt();
    }
}

