/*
 * Decompiled with CFR 0.152.
 */
package com.bartoszlipinski.viewpropertyobjectanimator;

import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import com.bartoszlipinski.viewpropertyobjectanimator.ChangeUpdateListener;

class DimensionChangeListener
extends ChangeUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    private final ViewGroup.LayoutParams mParams;
    private ChangeUpdateListener.IntValues mWidth;
    private ChangeUpdateListener.IntValues mHeight;

    DimensionChangeListener(View view) {
        super(view);
        this.mParams = view.getLayoutParams();
        if (this.mParams == null) {
            throw new IllegalStateException("View does not have layout params yet.");
        }
    }

    private int currentWidth() {
        return this.mParams.width > 0 ? this.mParams.width : (this.hasView() ? ((View)this.mView.get()).getWidth() : 0);
    }

    private int currentHeight() {
        return this.mParams.height > 0 ? this.mParams.height : (this.hasView() ? ((View)this.mView.get()).getHeight() : 0);
    }

    public void width(int width) {
        this.mWidth = new ChangeUpdateListener.IntValues(this, this.currentWidth(), width);
    }

    public void widthBy(int widthBy) {
        this.mWidth = new ChangeUpdateListener.IntValues(this, this.currentWidth(), this.currentWidth() + widthBy);
    }

    public void height(int height) {
        this.mHeight = new ChangeUpdateListener.IntValues(this, this.currentHeight(), height);
    }

    public void heightBy(int heightBy) {
        this.mHeight = new ChangeUpdateListener.IntValues(this, this.currentHeight(), this.currentHeight() + heightBy);
    }

    public void size(int size) {
        this.width(size);
        this.height(size);
    }

    public void sizeBy(int sizeBy) {
        this.widthBy(sizeBy);
        this.heightBy(sizeBy);
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        if (this.hasView()) {
            float animatedFraction = valueAnimator.getAnimatedFraction();
            if (this.mWidth != null) {
                this.mParams.width = (int)this.calculateAnimatedValue(this.mWidth.mFrom, this.mWidth.mTo, animatedFraction);
            }
            if (this.mHeight != null) {
                this.mParams.height = (int)this.calculateAnimatedValue(this.mHeight.mFrom, this.mHeight.mTo, animatedFraction);
            }
            ((View)this.mView.get()).requestLayout();
        }
    }
}

