/*
 * Decompiled with CFR 0.152.
 */
package com.bartoszlipinski.viewpropertyobjectanimator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.os.Build;
import android.support.v4.util.ArrayMap;
import android.util.Property;
import android.view.View;
import android.view.animation.Interpolator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ViewPropertyObjectAnimator {
    private final WeakReference<View> mView;
    private long mDuration = -1L;
    private long mStartDelay = -1L;
    private boolean mWithLayer = false;
    private Interpolator mInterpolator;
    private List<Animator.AnimatorListener> mListeners = new ArrayList<Animator.AnimatorListener>();
    private List<ValueAnimator.AnimatorUpdateListener> mUpdateListeners = new ArrayList<ValueAnimator.AnimatorUpdateListener>();
    private List<Animator.AnimatorPauseListener> mPauseListeners = new ArrayList<Animator.AnimatorPauseListener>();
    private ArrayMap<Property<View, Float>, PropertyValuesHolder> mPropertyHoldersMap = new ArrayMap();

    private ViewPropertyObjectAnimator(View view) {
        this.mView = new WeakReference<View>(view);
    }

    public static ViewPropertyObjectAnimator animate(View view) {
        return new ViewPropertyObjectAnimator(view);
    }

    private void animateProperty(Property<View, Float> property, float toValue) {
        if (this.hasView()) {
            float fromValue = ((Float)property.get(this.mView.get())).floatValue();
            this.animatePropertyBetween(property, fromValue, toValue);
        }
    }

    private void animatePropertyBy(Property<View, Float> property, float byValue) {
        if (this.hasView()) {
            float fromValue = ((Float)property.get(this.mView.get())).floatValue();
            float toValue = fromValue + byValue;
            this.animatePropertyBetween(property, fromValue, toValue);
        }
    }

    private void animatePropertyBetween(Property<View, Float> property, float fromValue, float toValue) {
        this.mPropertyHoldersMap.remove(property);
        this.mPropertyHoldersMap.put(property, (Object)PropertyValuesHolder.ofFloat(property, (float[])new float[]{fromValue, toValue}));
    }

    public ViewPropertyObjectAnimator scaleX(float scaleX) {
        this.animateProperty((Property<View, Float>)View.SCALE_X, scaleX);
        return this;
    }

    public ViewPropertyObjectAnimator scaleXBy(float scaleXBy) {
        this.animatePropertyBy((Property<View, Float>)View.SCALE_X, scaleXBy);
        return this;
    }

    public ViewPropertyObjectAnimator scaleY(float scaleY) {
        this.animateProperty((Property<View, Float>)View.SCALE_Y, scaleY);
        return this;
    }

    public ViewPropertyObjectAnimator scaleYBy(float scaleYBy) {
        this.animatePropertyBy((Property<View, Float>)View.SCALE_Y, scaleYBy);
        return this;
    }

    public ViewPropertyObjectAnimator scales(float scales) {
        this.scaleY(scales);
        this.scaleX(scales);
        return this;
    }

    public ViewPropertyObjectAnimator scalesBy(float scalesBy) {
        this.scaleYBy(scalesBy);
        this.scaleXBy(scalesBy);
        return this;
    }

    public ViewPropertyObjectAnimator translationX(float translationX) {
        this.animateProperty((Property<View, Float>)View.TRANSLATION_X, translationX);
        return this;
    }

    public ViewPropertyObjectAnimator translationXBy(float translationXBy) {
        this.animatePropertyBy((Property<View, Float>)View.TRANSLATION_X, translationXBy);
        return this;
    }

    public ViewPropertyObjectAnimator translationY(float translationY) {
        this.animateProperty((Property<View, Float>)View.TRANSLATION_Y, translationY);
        return this;
    }

    public ViewPropertyObjectAnimator translationYBy(float translationYBy) {
        this.animatePropertyBy((Property<View, Float>)View.TRANSLATION_Y, translationYBy);
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewPropertyObjectAnimator translationZ(float translationZ) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.animateProperty((Property<View, Float>)View.TRANSLATION_Z, translationZ);
        }
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewPropertyObjectAnimator translationZBy(float translationZBy) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.animatePropertyBy((Property<View, Float>)View.TRANSLATION_Z, translationZBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator alpha(float alpha) {
        this.animateProperty((Property<View, Float>)View.ALPHA, alpha);
        return this;
    }

    public ViewPropertyObjectAnimator alphaBy(float alphaBy) {
        this.animatePropertyBy((Property<View, Float>)View.ALPHA, alphaBy);
        return this;
    }

    public ViewPropertyObjectAnimator rotation(float rotation) {
        this.animateProperty((Property<View, Float>)View.ROTATION, rotation);
        return this;
    }

    public ViewPropertyObjectAnimator rotationBy(float rotationBy) {
        this.animatePropertyBy((Property<View, Float>)View.ROTATION, rotationBy);
        return this;
    }

    public ViewPropertyObjectAnimator rotationX(float rotationX) {
        this.animateProperty((Property<View, Float>)View.ROTATION_X, rotationX);
        return this;
    }

    public ViewPropertyObjectAnimator rotationXBy(float rotationXBy) {
        this.animatePropertyBy((Property<View, Float>)View.ROTATION_X, rotationXBy);
        return this;
    }

    public ViewPropertyObjectAnimator rotationY(float rotationY) {
        this.animateProperty((Property<View, Float>)View.ROTATION_Y, rotationY);
        return this;
    }

    public ViewPropertyObjectAnimator rotationYBy(float rotationYBy) {
        this.animatePropertyBy((Property<View, Float>)View.ROTATION_Y, rotationYBy);
        return this;
    }

    public ViewPropertyObjectAnimator x(float x) {
        this.animateProperty((Property<View, Float>)View.X, x);
        return this;
    }

    public ViewPropertyObjectAnimator xBy(float xBy) {
        this.animatePropertyBy((Property<View, Float>)View.X, xBy);
        return this;
    }

    public ViewPropertyObjectAnimator y(float y) {
        this.animateProperty((Property<View, Float>)View.Y, y);
        return this;
    }

    public ViewPropertyObjectAnimator yBy(float yBy) {
        this.animatePropertyBy((Property<View, Float>)View.Y, yBy);
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewPropertyObjectAnimator z(float z) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.animateProperty((Property<View, Float>)View.Z, z);
        }
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewPropertyObjectAnimator zBy(float zBy) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.animatePropertyBy((Property<View, Float>)View.Z, zBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator withLayer() {
        this.mWithLayer = true;
        return this;
    }

    public ViewPropertyObjectAnimator setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            throw new IllegalArgumentException("startDelay cannot be < 0");
        }
        this.mStartDelay = startDelay;
        return this;
    }

    public ViewPropertyObjectAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration cannot be < 0");
        }
        this.mDuration = duration;
        return this;
    }

    public ViewPropertyObjectAnimator setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    public ViewPropertyObjectAnimator addListener(Animator.AnimatorListener listener) {
        this.mListeners.add(listener);
        return this;
    }

    public ViewPropertyObjectAnimator removeListener(Animator.AnimatorListener listener) {
        this.mListeners.remove(listener);
        return this;
    }

    public ViewPropertyObjectAnimator removeAllListeners() {
        this.mListeners.clear();
        return this;
    }

    public ViewPropertyObjectAnimator addUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
        this.mUpdateListeners.add(listener);
        return this;
    }

    public ViewPropertyObjectAnimator removeUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
        this.mUpdateListeners.remove(listener);
        return this;
    }

    public ViewPropertyObjectAnimator removeAllUpdateListeners() {
        this.mUpdateListeners.clear();
        return this;
    }

    public ViewPropertyObjectAnimator addPauseListener(Animator.AnimatorPauseListener listener) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mPauseListeners.add(listener);
        }
        return this;
    }

    public ViewPropertyObjectAnimator removePauseListener(Animator.AnimatorPauseListener listener) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mPauseListeners.remove(listener);
        }
        return this;
    }

    public ViewPropertyObjectAnimator removeAllPauseListeners() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mPauseListeners.clear();
        }
        return this;
    }

    public ViewPropertyObjectAnimator withStartAction(final Runnable runnable) {
        return this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                runnable.run();
                ViewPropertyObjectAnimator.this.removeListener((Animator.AnimatorListener)this);
            }
        });
    }

    public ViewPropertyObjectAnimator withEndAction(final Runnable runnable) {
        return this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                runnable.run();
                ViewPropertyObjectAnimator.this.removeListener((Animator.AnimatorListener)this);
            }
        });
    }

    private boolean hasView() {
        return this.mView.get() != null;
    }

    @SuppressLint(value={"NewApi"})
    public ObjectAnimator get() {
        if (this.hasView()) {
            Collection holders = this.mPropertyHoldersMap.values();
            ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder(this.mView.get(), (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
            if (this.mWithLayer) {
                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationStart(Animator animation) {
                        if (ViewPropertyObjectAnimator.this.hasView()) {
                            ((View)ViewPropertyObjectAnimator.this.mView.get()).setLayerType(2, null);
                        }
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (ViewPropertyObjectAnimator.this.hasView()) {
                            ((View)ViewPropertyObjectAnimator.this.mView.get()).setLayerType(0, null);
                        }
                    }
                });
            }
            if (this.mStartDelay != -1L) {
                animator.setStartDelay(this.mStartDelay);
            }
            if (this.mDuration != -1L) {
                animator.setDuration(this.mDuration);
            }
            if (this.mInterpolator != null) {
                animator.setInterpolator((TimeInterpolator)this.mInterpolator);
            }
            for (Animator.AnimatorListener animatorListener : this.mListeners) {
                animator.addListener(animatorListener);
            }
            for (ValueAnimator.AnimatorUpdateListener animatorUpdateListener : this.mUpdateListeners) {
                animator.addUpdateListener(animatorUpdateListener);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                for (Animator.AnimatorPauseListener animatorPauseListener : this.mPauseListeners) {
                    animator.addPauseListener(animatorPauseListener);
                }
            }
            return animator;
        }
        return ObjectAnimator.ofFloat(null, (Property)View.ALPHA, (float[])new float[]{1.0f, 1.0f});
    }

    public void start() {
        this.get().start();
    }
}

