/*
 * Decompiled with CFR 0.152.
 */
package com.baoyz.actionsheet;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.baoyz.actionsheet.R;

public class ActionSheet
extends Fragment
implements View.OnClickListener {
    private static final String ARG_CANCEL_BUTTON_TITLE = "cancel_button_title";
    private static final String ARG_OTHER_BUTTON_TITLES = "other_button_titles";
    private static final String ARG_CANCELABLE_ONTOUCHOUTSIDE = "cancelable_ontouchoutside";
    private static final int CANCEL_BUTTON_ID = 100;
    private static final int BG_VIEW_ID = 10;
    private static final int TRANSLATE_DURATION = 200;
    private static final int ALPHA_DURATION = 300;
    private boolean mDismissed = true;
    private ActionSheetListener mListener;
    private View mView;
    private LinearLayout mPanel;
    private ViewGroup mGroup;
    private View mBg;
    private Attributes mAttrs;
    private boolean isCancel = true;

    public void show(FragmentManager manager, String tag) {
        if (!this.mDismissed) {
            return;
        }
        this.mDismissed = false;
        FragmentTransaction ft = manager.beginTransaction();
        ft.add((Fragment)this, tag);
        ft.addToBackStack(null);
        ft.commit();
    }

    public void dismiss() {
        if (this.mDismissed) {
            return;
        }
        this.mDismissed = true;
        this.getFragmentManager().popBackStack();
        FragmentTransaction ft = this.getFragmentManager().beginTransaction();
        ft.remove((Fragment)this);
        ft.commit();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View focusView;
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        if (imm.isActive() && (focusView = this.getActivity().getCurrentFocus()) != null) {
            imm.hideSoftInputFromWindow(focusView.getWindowToken(), 0);
        }
        this.mAttrs = this.readAttribute();
        this.mView = this.createView();
        this.mGroup = (ViewGroup)this.getActivity().getWindow().getDecorView();
        this.createItems();
        this.mGroup.addView(this.mView);
        this.mBg.startAnimation(this.createAlphaInAnimation());
        this.mPanel.startAnimation(this.createTranslationInAnimation());
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    private Animation createTranslationInAnimation() {
        int type = 1;
        TranslateAnimation an = new TranslateAnimation(type, 0.0f, type, 0.0f, type, 1.0f, type, 0.0f);
        an.setDuration(200L);
        return an;
    }

    private Animation createAlphaInAnimation() {
        AlphaAnimation an = new AlphaAnimation(0.0f, 1.0f);
        an.setDuration(300L);
        return an;
    }

    private Animation createTranslationOutAnimation() {
        int type = 1;
        TranslateAnimation an = new TranslateAnimation(type, 0.0f, type, 0.0f, type, 0.0f, type, 1.0f);
        an.setDuration(200L);
        an.setFillAfter(true);
        return an;
    }

    private Animation createAlphaOutAnimation() {
        AlphaAnimation an = new AlphaAnimation(1.0f, 0.0f);
        an.setDuration(300L);
        an.setFillAfter(true);
        return an;
    }

    private View createView() {
        FrameLayout parent = new FrameLayout((Context)this.getActivity());
        parent.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mBg = new View((Context)this.getActivity());
        this.mBg.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mBg.setBackgroundColor(Color.argb((int)136, (int)0, (int)0, (int)0));
        this.mBg.setId(10);
        this.mBg.setOnClickListener((View.OnClickListener)this);
        this.mPanel = new LinearLayout((Context)this.getActivity());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        params.gravity = 80;
        this.mPanel.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mPanel.setOrientation(1);
        parent.addView(this.mBg);
        parent.addView((View)this.mPanel);
        return parent;
    }

    private void createItems() {
        String[] titles = this.getOtherButtonTitles();
        if (titles != null) {
            for (int i = 0; i < titles.length; ++i) {
                Button bt = new Button((Context)this.getActivity());
                bt.setId(100 + i + 1);
                bt.setOnClickListener((View.OnClickListener)this);
                bt.setBackgroundDrawable(this.getOtherButtonBg(titles, i));
                bt.setText((CharSequence)titles[i]);
                bt.setTextColor(this.mAttrs.otherButtonTextColor);
                bt.setTextSize(0, this.mAttrs.actionSheetTextSize);
                if (i > 0) {
                    LinearLayout.LayoutParams params = this.createButtonLayoutParams();
                    params.topMargin = this.mAttrs.otherButtonSpacing;
                    this.mPanel.addView((View)bt, (ViewGroup.LayoutParams)params);
                    continue;
                }
                this.mPanel.addView((View)bt);
            }
        }
        Button bt = new Button((Context)this.getActivity());
        bt.getPaint().setFakeBoldText(true);
        bt.setTextSize(0, this.mAttrs.actionSheetTextSize);
        bt.setId(100);
        bt.setBackgroundDrawable(this.mAttrs.cancelButtonBackground);
        bt.setText((CharSequence)this.getCancelButtonTitle());
        bt.setTextColor(this.mAttrs.cancelButtonTextColor);
        bt.setOnClickListener((View.OnClickListener)this);
        LinearLayout.LayoutParams params = this.createButtonLayoutParams();
        params.topMargin = this.mAttrs.cancelButtonMarginTop;
        this.mPanel.addView((View)bt, (ViewGroup.LayoutParams)params);
        this.mPanel.setBackgroundDrawable(this.mAttrs.background);
        this.mPanel.setPadding(this.mAttrs.padding, this.mAttrs.padding, this.mAttrs.padding, this.mAttrs.padding);
    }

    public LinearLayout.LayoutParams createButtonLayoutParams() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        return params;
    }

    private Drawable getOtherButtonBg(String[] titles, int i) {
        if (titles.length == 1) {
            return this.mAttrs.otherButtonSingleBackground;
        }
        if (titles.length == 2) {
            switch (i) {
                case 0: {
                    return this.mAttrs.otherButtonTopBackground;
                }
                case 1: {
                    return this.mAttrs.otherButtonBottomBackground;
                }
            }
        }
        if (titles.length > 2) {
            if (i == 0) {
                return this.mAttrs.otherButtonTopBackground;
            }
            if (i == titles.length - 1) {
                return this.mAttrs.otherButtonBottomBackground;
            }
            return this.mAttrs.getOtherButtonMiddleBackground();
        }
        return null;
    }

    public void onDestroyView() {
        this.mPanel.startAnimation(this.createTranslationOutAnimation());
        this.mBg.startAnimation(this.createAlphaOutAnimation());
        this.mView.postDelayed(new Runnable(){

            @Override
            public void run() {
                ActionSheet.this.mGroup.removeView(ActionSheet.this.mView);
            }
        }, 300L);
        if (this.mListener != null) {
            this.mListener.onDismiss(this, this.isCancel);
        }
        super.onDestroyView();
    }

    private Attributes readAttribute() {
        Drawable otherButtonSingleBackground;
        Drawable otherButtonBottomBackground;
        Drawable otherButtonMiddleBackground;
        Drawable otherButtonTopBackground;
        Drawable cancelButtonBackground;
        Attributes attrs = new Attributes((Context)this.getActivity());
        TypedArray a = this.getActivity().getTheme().obtainStyledAttributes(null, R.styleable.ActionSheet, R.attr.actionSheetStyle, 0);
        Drawable background = a.getDrawable(R.styleable.ActionSheet_actionSheetBackground);
        if (background != null) {
            attrs.background = background;
        }
        if ((cancelButtonBackground = a.getDrawable(R.styleable.ActionSheet_cancelButtonBackground)) != null) {
            attrs.cancelButtonBackground = cancelButtonBackground;
        }
        if ((otherButtonTopBackground = a.getDrawable(R.styleable.ActionSheet_otherButtonTopBackground)) != null) {
            attrs.otherButtonTopBackground = otherButtonTopBackground;
        }
        if ((otherButtonMiddleBackground = a.getDrawable(R.styleable.ActionSheet_otherButtonMiddleBackground)) != null) {
            attrs.otherButtonMiddleBackground = otherButtonMiddleBackground;
        }
        if ((otherButtonBottomBackground = a.getDrawable(R.styleable.ActionSheet_otherButtonBottomBackground)) != null) {
            attrs.otherButtonBottomBackground = otherButtonBottomBackground;
        }
        if ((otherButtonSingleBackground = a.getDrawable(R.styleable.ActionSheet_otherButtonSingleBackground)) != null) {
            attrs.otherButtonSingleBackground = otherButtonSingleBackground;
        }
        attrs.cancelButtonTextColor = a.getColor(R.styleable.ActionSheet_cancelButtonTextColor, attrs.cancelButtonTextColor);
        attrs.otherButtonTextColor = a.getColor(R.styleable.ActionSheet_otherButtonTextColor, attrs.otherButtonTextColor);
        attrs.padding = (int)a.getDimension(R.styleable.ActionSheet_actionSheetPadding, (float)attrs.padding);
        attrs.otherButtonSpacing = (int)a.getDimension(R.styleable.ActionSheet_otherButtonSpacing, (float)attrs.otherButtonSpacing);
        attrs.cancelButtonMarginTop = (int)a.getDimension(R.styleable.ActionSheet_cancelButtonMarginTop, (float)attrs.cancelButtonMarginTop);
        attrs.actionSheetTextSize = a.getDimensionPixelSize(R.styleable.ActionSheet_actionSheetTextSize, (int)attrs.actionSheetTextSize);
        a.recycle();
        return attrs;
    }

    private String getCancelButtonTitle() {
        return this.getArguments().getString(ARG_CANCEL_BUTTON_TITLE);
    }

    private String[] getOtherButtonTitles() {
        return this.getArguments().getStringArray(ARG_OTHER_BUTTON_TITLES);
    }

    private boolean getCancelableOnTouchOutside() {
        return this.getArguments().getBoolean(ARG_CANCELABLE_ONTOUCHOUTSIDE);
    }

    public void setActionSheetListener(ActionSheetListener listener) {
        this.mListener = listener;
    }

    public void onClick(View v) {
        if (v.getId() == 10 && !this.getCancelableOnTouchOutside()) {
            return;
        }
        this.dismiss();
        if (v.getId() != 100 && v.getId() != 10) {
            if (this.mListener != null) {
                this.mListener.onOtherButtonClick(this, v.getId() - 100 - 1);
            }
            this.isCancel = false;
        }
    }

    public static Builder createBuilder(Context context, FragmentManager fragmentManager) {
        return new Builder(context, fragmentManager);
    }

    public static interface ActionSheetListener {
        public void onDismiss(ActionSheet var1, boolean var2);

        public void onOtherButtonClick(ActionSheet var1, int var2);
    }

    public static class Builder {
        private Context mContext;
        private FragmentManager mFragmentManager;
        private String mCancelButtonTitle;
        private String[] mOtherButtonTitles;
        private String mTag = "actionSheet";
        private boolean mCancelableOnTouchOutside;
        private ActionSheetListener mListener;

        public Builder(Context context, FragmentManager fragmentManager) {
            this.mContext = context;
            this.mFragmentManager = fragmentManager;
        }

        public Builder setCancelButtonTitle(String title) {
            this.mCancelButtonTitle = title;
            return this;
        }

        public Builder setCancelButtonTitle(int strId) {
            return this.setCancelButtonTitle(this.mContext.getString(strId));
        }

        public Builder setOtherButtonTitles(String ... titles) {
            this.mOtherButtonTitles = titles;
            return this;
        }

        public Builder setTag(String tag) {
            this.mTag = tag;
            return this;
        }

        public Builder setListener(ActionSheetListener listener) {
            this.mListener = listener;
            return this;
        }

        public Builder setCancelableOnTouchOutside(boolean cancelable) {
            this.mCancelableOnTouchOutside = cancelable;
            return this;
        }

        public Bundle prepareArguments() {
            Bundle bundle = new Bundle();
            bundle.putString(ActionSheet.ARG_CANCEL_BUTTON_TITLE, this.mCancelButtonTitle);
            bundle.putStringArray(ActionSheet.ARG_OTHER_BUTTON_TITLES, this.mOtherButtonTitles);
            bundle.putBoolean(ActionSheet.ARG_CANCELABLE_ONTOUCHOUTSIDE, this.mCancelableOnTouchOutside);
            return bundle;
        }

        public ActionSheet show() {
            ActionSheet actionSheet = (ActionSheet)Fragment.instantiate((Context)this.mContext, (String)ActionSheet.class.getName(), (Bundle)this.prepareArguments());
            actionSheet.setActionSheetListener(this.mListener);
            actionSheet.show(this.mFragmentManager, this.mTag);
            return actionSheet;
        }
    }

    private static class Attributes {
        private Context mContext;
        Drawable background;
        Drawable cancelButtonBackground;
        Drawable otherButtonTopBackground;
        Drawable otherButtonMiddleBackground;
        Drawable otherButtonBottomBackground;
        Drawable otherButtonSingleBackground;
        int cancelButtonTextColor;
        int otherButtonTextColor;
        int padding;
        int otherButtonSpacing;
        int cancelButtonMarginTop;
        float actionSheetTextSize;

        public Attributes(Context context) {
            this.mContext = context;
            this.background = new ColorDrawable(0);
            this.cancelButtonBackground = new ColorDrawable(-16777216);
            ColorDrawable gray = new ColorDrawable(-7829368);
            this.otherButtonTopBackground = gray;
            this.otherButtonMiddleBackground = gray;
            this.otherButtonBottomBackground = gray;
            this.otherButtonSingleBackground = gray;
            this.cancelButtonTextColor = -1;
            this.otherButtonTextColor = -16777216;
            this.padding = this.dp2px(20);
            this.otherButtonSpacing = this.dp2px(2);
            this.cancelButtonMarginTop = this.dp2px(10);
            this.actionSheetTextSize = this.dp2px(16);
        }

        private int dp2px(int dp) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        }

        public Drawable getOtherButtonMiddleBackground() {
            if (this.otherButtonMiddleBackground instanceof StateListDrawable) {
                TypedArray a = this.mContext.getTheme().obtainStyledAttributes(null, R.styleable.ActionSheet, R.attr.actionSheetStyle, 0);
                this.otherButtonMiddleBackground = a.getDrawable(R.styleable.ActionSheet_otherButtonMiddleBackground);
                a.recycle();
            }
            return this.otherButtonMiddleBackground;
        }
    }
}

