/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.pagination;

import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.RowBounds;

public class Pagination
extends RowBounds
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient int offset;
    private transient int limit;
    private int total;
    private int size = 10;
    private int pages;
    private int current = 1;
    private transient boolean searchCount = true;
    private transient boolean openSort = true;
    private transient List<String> ascs;
    private transient List<String> descs;
    private transient boolean isAsc = true;
    private transient String orderByField;

    public Pagination() {
    }

    public Pagination(int current, int size) {
        this(current, size, true);
    }

    public Pagination(int current, int size, boolean searchCount) {
        this(current, size, searchCount, true);
    }

    public Pagination(int current, int size, boolean searchCount, boolean openSort) {
        super(Pagination.offsetCurrent(current, size), size);
        this.setOffset(Pagination.offsetCurrent(current, size));
        this.setLimit(size);
        if (current > 1) {
            this.current = current;
        }
        this.size = size;
        this.searchCount = searchCount;
        this.openSort = openSort;
    }

    protected static int offsetCurrent(int current, int size) {
        if (current > 0) {
            return (current - 1) * size;
        }
        return 0;
    }

    public int offsetCurrent() {
        return Pagination.offsetCurrent(this.current, this.size);
    }

    public boolean hasPrevious() {
        return this.current > 1;
    }

    public boolean hasNext() {
        return this.current < this.pages;
    }

    public int getTotal() {
        return this.total;
    }

    public Pagination setTotal(int total) {
        this.total = total;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Pagination setSize(int size) {
        this.size = size;
        return this;
    }

    public int getPages() {
        if (this.size == 0) {
            return 0;
        }
        this.pages = this.total / this.size;
        if (this.total % this.size != 0) {
            ++this.pages;
        }
        return this.pages;
    }

    public int getCurrent() {
        return this.current;
    }

    public Pagination setCurrent(int current) {
        this.current = current;
        return this;
    }

    public boolean isSearchCount() {
        return this.searchCount;
    }

    public Pagination setSearchCount(boolean searchCount) {
        this.searchCount = searchCount;
        return this;
    }

    @Deprecated
    public String getOrderByField() {
        return this.orderByField;
    }

    public Pagination setOrderByField(String orderByField) {
        if (StringUtils.isNotEmpty(orderByField)) {
            this.orderByField = orderByField;
        }
        return this;
    }

    public boolean isOpenSort() {
        return this.openSort;
    }

    public Pagination setOpenSort(boolean openSort) {
        this.openSort = openSort;
        return this;
    }

    public List<String> getAscs() {
        return this.orders(this.isAsc, this.ascs);
    }

    private List<String> orders(boolean condition, List<String> columns) {
        if (condition && StringUtils.isNotEmpty(this.orderByField)) {
            if (columns == null) {
                columns = new ArrayList<String>();
            }
            if (!columns.contains(this.orderByField)) {
                columns.add(this.orderByField);
            }
        }
        return columns;
    }

    public Pagination setAscs(List<String> ascs) {
        this.ascs = ascs;
        return this;
    }

    public List<String> getDescs() {
        return this.orders(!this.isAsc, this.descs);
    }

    public Pagination setDescs(List<String> descs) {
        this.descs = descs;
        return this;
    }

    @Deprecated
    public boolean isAsc() {
        return this.isAsc;
    }

    public Pagination setAsc(boolean isAsc) {
        this.isAsc = isAsc;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public Pagination setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Pagination setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public String toString() {
        return "Pagination { total=" + this.total + " ,size=" + this.size + " ,pages=" + this.pages + " ,current=" + this.current + " }";
    }
}

