/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.jsqlparser;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JsqlParserThreadPool {
    public static final int DEFAULT_THREAD_SIZE = (Runtime.getRuntime().availableProcessors() + 1) / 2;

    public static ExecutorService getDefaultThreadPoolExecutor() {
        return DefaultJsqlParserFixedThreadPool.INSTANCE.getDefaultThreadPoolExecutor();
    }

    public static void addShutdownHook(ExecutorService executorService) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!executorService.isShutdown()) {
                executorService.shutdown();
            }
        }, "mybatis-plus-jsqlParser-shutdown-hook"));
    }

    private static class DefaultJsqlParserFixedThreadPool {
        private static final DefaultJsqlParserFixedThreadPool INSTANCE = new DefaultJsqlParserFixedThreadPool();
        public static ExecutorService executorService = new ThreadPoolExecutor(DEFAULT_THREAD_SIZE, DEFAULT_THREAD_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread thread = new Thread(r);
            thread.setName("mybatis-plus-jsqlParser-" + thread.getId());
            thread.setDaemon(true);
            return thread;
        });

        private DefaultJsqlParserFixedThreadPool() {
        }

        public ExecutorService getDefaultThreadPoolExecutor() {
            return executorService;
        }

        static {
            JsqlParserThreadPool.addShutdownHook(executorService);
        }
    }
}

