/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.parser.cache;

import com.baomidou.mybatisplus.extension.parser.cache.JsqlParseCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public abstract class AbstractCaffeineJsqlParseCache
implements JsqlParseCache {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Cache<String, byte[]> cache;
    protected boolean async = false;
    protected Executor executor;

    public AbstractCaffeineJsqlParseCache(Cache<String, byte[]> cache) {
        this.cache = cache;
    }

    public AbstractCaffeineJsqlParseCache(Consumer<Caffeine<Object, Object>> consumer) {
        Caffeine caffeine = Caffeine.newBuilder();
        consumer.accept((Caffeine<Object, Object>)caffeine);
        this.cache = caffeine.build();
    }

    @Override
    public void putStatement(String sql, Statement value) {
        this.put(sql, value);
    }

    @Override
    public void putStatements(String sql, Statements value) {
        this.put(sql, value);
    }

    @Override
    public Statement getStatement(String sql) {
        return (Statement)this.get(sql);
    }

    @Override
    public Statements getStatements(String sql) {
        return (Statements)this.get(sql);
    }

    protected <T> T get(String sql) {
        byte[] bytes = (byte[])this.cache.getIfPresent((Object)sql);
        if (null != bytes) {
            try {
                return (T)this.deserialize(sql, bytes);
            }
            catch (Exception e) {
                this.cache.invalidate((Object)sql);
                this.logger.error("deserialize error", (Throwable)e);
            }
        }
        return null;
    }

    protected void put(String sql, Object value) {
        byte[] serialVal = this.serialize(value);
        if (this.async) {
            if (this.executor != null) {
                CompletableFuture.runAsync(() -> this.cache.put((Object)sql, (Object)serialVal), this.executor);
            } else {
                CompletableFuture.runAsync(() -> this.cache.put((Object)sql, (Object)serialVal));
            }
        } else {
            this.cache.put((Object)sql, (Object)serialVal);
        }
    }

    public abstract byte[] serialize(Object var1);

    public abstract Object deserialize(String var1, byte[] var2);

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

