/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.Controller;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.builder.Mapper;
import com.baomidou.mybatisplus.generator.config.builder.Service;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class PathInfoHandler {
    private final Map<OutputFile, String> pathInfo = new HashMap<OutputFile, String>();
    private final String outputDir;
    private final PackageConfig packageConfig;

    PathInfoHandler(GlobalConfig globalConfig, StrategyConfig strategyConfig, PackageConfig packageConfig) {
        this.outputDir = globalConfig.getOutputDir();
        this.packageConfig = packageConfig;
        this.setDefaultPathInfo(globalConfig, strategyConfig);
        Map<OutputFile, String> pathInfo = packageConfig.getPathInfo();
        if (CollectionUtils.isNotEmpty(pathInfo)) {
            this.pathInfo.putAll(pathInfo);
        }
    }

    private void setDefaultPathInfo(GlobalConfig globalConfig, StrategyConfig strategyConfig) {
        Controller controller;
        Service service;
        Mapper mapper;
        Entity entity = strategyConfig.entity();
        if (entity.isGenerate()) {
            this.putPathInfo(globalConfig.isKotlin() ? entity.getKotlinTemplate() : entity.getJavaTemplate(), OutputFile.entity, "Entity");
        }
        if ((mapper = strategyConfig.mapper()).isGenerateMapper()) {
            this.putPathInfo(mapper.getMapperTemplatePath(), OutputFile.mapper, "Mapper");
        }
        if (mapper.isGenerateMapperXml()) {
            this.putPathInfo(mapper.getMapperXmlTemplatePath(), OutputFile.xml, "Xml");
        }
        if ((service = strategyConfig.service()).isGenerateService()) {
            this.putPathInfo(service.getServiceTemplate(), OutputFile.service, "Service");
        }
        if (service.isGenerateServiceImpl()) {
            this.putPathInfo(service.getServiceImplTemplate(), OutputFile.serviceImpl, "ServiceImpl");
        }
        if ((controller = strategyConfig.controller()).isGenerate()) {
            this.putPathInfo(controller.getTemplatePath(), OutputFile.controller, "Controller");
        }
        this.putPathInfo(OutputFile.parent, "Parent");
    }

    private void putPathInfo(String template, OutputFile outputFile, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            this.putPathInfo(outputFile, module);
        }
    }

    private void putPathInfo(OutputFile outputFile, String module) {
        this.pathInfo.putIfAbsent(outputFile, this.joinPath(this.outputDir, this.packageConfig.getPackageInfo(module)));
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    public Map<OutputFile, String> getPathInfo() {
        return this.pathInfo;
    }
}

