/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.po;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.IKeyWordsHandler;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.fill.Column;
import com.baomidou.mybatisplus.generator.fill.Property;
import com.baomidou.mybatisplus.generator.jdbc.DatabaseMetaDataWrapper;
import java.util.Map;
import org.apache.ibatis.type.JdbcType;
import org.jetbrains.annotations.NotNull;

public class TableField {
    private boolean convert;
    private boolean keyFlag;
    private boolean keyIdentityFlag;
    private String name;
    private String type;
    private String propertyName;
    private IColumnType columnType;
    private String comment;
    private String fill;
    private boolean keyWords;
    private String columnName;
    private Map<String, Object> customMap;
    private MetaInfo metaInfo;
    private final Entity entity;
    private final DataSourceConfig dataSourceConfig;
    private final GlobalConfig globalConfig;

    public TableField(@NotNull ConfigBuilder configBuilder, @NotNull String name) {
        this.name = name;
        this.columnName = name;
        this.entity = configBuilder.getStrategyConfig().entity();
        this.dataSourceConfig = configBuilder.getDataSourceConfig();
        this.globalConfig = configBuilder.getGlobalConfig();
    }

    public TableField setPropertyName(@NotNull String propertyName, @NotNull IColumnType columnType) {
        this.columnType = columnType;
        if (this.entity.isBooleanColumnRemoveIsPrefix() && "boolean".equalsIgnoreCase(this.getPropertyType()) && propertyName.startsWith("is")) {
            this.convert = true;
            this.propertyName = StringUtils.removePrefixAfterPrefixToLower((String)propertyName, (int)2);
            return this;
        }
        if (this.entity.getColumnNaming() != NamingStrategy.underline_to_camel) {
            boolean bl = this.convert = !propertyName.equalsIgnoreCase(this.columnName);
        }
        if (this.entity.isTableFieldAnnotationEnable()) {
            this.convert = true;
        }
        this.propertyName = propertyName;
        return this;
    }

    public String getPropertyType() {
        if (null != this.columnType) {
            return this.columnType.getType();
        }
        return null;
    }

    public String getCapitalName() {
        if (this.propertyName.length() == 1) {
            return this.propertyName.toUpperCase();
        }
        if (Character.isLowerCase(this.propertyName.charAt(1))) {
            return Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
        }
        return this.propertyName;
    }

    public String getAnnotationColumnName() {
        if (this.keyWords && this.columnName.startsWith("\"")) {
            return String.format("\\\"%s\\\"", this.name);
        }
        return this.columnName;
    }

    public boolean isVersionField() {
        String propertyName = this.entity.getVersionPropertyName();
        String columnName = this.entity.getVersionColumnName();
        return StringUtils.isNotBlank((CharSequence)propertyName) && this.propertyName.equals(propertyName) || StringUtils.isNotBlank((CharSequence)columnName) && this.name.equalsIgnoreCase(columnName);
    }

    public boolean isLogicDeleteField() {
        String propertyName = this.entity.getLogicDeletePropertyName();
        String columnName = this.entity.getLogicDeleteColumnName();
        return StringUtils.isNotBlank((CharSequence)propertyName) && this.propertyName.equals(propertyName) || StringUtils.isNotBlank((CharSequence)columnName) && this.name.equalsIgnoreCase(columnName);
    }

    public TableField primaryKey(boolean autoIncrement) {
        this.keyFlag = true;
        this.keyIdentityFlag = autoIncrement;
        return this;
    }

    public TableField setType(String type) {
        this.type = type;
        return this;
    }

    public TableField setComment(String comment) {
        this.comment = this.globalConfig.isSwagger() && StringUtils.isNotBlank((CharSequence)comment) ? comment.replace("\"", "\\\"") : comment;
        return this;
    }

    public TableField setColumnName(String columnName) {
        this.columnName = columnName;
        IKeyWordsHandler keyWordsHandler = this.dataSourceConfig.getKeyWordsHandler();
        if (keyWordsHandler != null && keyWordsHandler.isKeyWords(columnName)) {
            this.keyWords = true;
            this.columnName = keyWordsHandler.formatColumn(columnName);
        }
        return this;
    }

    public TableField setCustomMap(Map<String, Object> customMap) {
        this.customMap = customMap;
        return this;
    }

    public boolean isConvert() {
        return this.convert;
    }

    public boolean isKeyFlag() {
        return this.keyFlag;
    }

    public boolean isKeyIdentityFlag() {
        return this.keyIdentityFlag;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public IColumnType getColumnType() {
        return this.columnType;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFill() {
        if (StringUtils.isBlank((CharSequence)this.fill)) {
            this.entity.getTableFillList().stream().filter(tf -> tf instanceof Column && tf.getName().equalsIgnoreCase(this.name) || tf instanceof Property && tf.getName().equals(this.propertyName)).findFirst().ifPresent(tf -> {
                this.fill = tf.getFieldFill().name();
            });
        }
        return this.fill;
    }

    public boolean isKeyWords() {
        return this.keyWords;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Map<String, Object> getCustomMap() {
        return this.customMap;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public static class MetaInfo {
        private int length;
        private boolean nullable;
        private String remarks;
        private String defaultValue;
        private int scale;
        private JdbcType jdbcType;

        public MetaInfo(DatabaseMetaDataWrapper.ColumnsInfo columnsInfo) {
            if (columnsInfo != null) {
                this.length = columnsInfo.getLength();
                this.nullable = columnsInfo.isNullable();
                this.remarks = columnsInfo.getRemarks();
                this.defaultValue = columnsInfo.getDefaultValue();
                this.scale = columnsInfo.getScale();
                this.jdbcType = columnsInfo.getJdbcType();
            }
        }

        public int getLength() {
            return this.length;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getScale() {
            return this.scale;
        }

        public JdbcType getJdbcType() {
            return this.jdbcType;
        }

        public String toString() {
            return "MetaInfo{length=" + this.length + ", nullable=" + this.nullable + ", remarks='" + this.remarks + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", scale=" + this.scale + ", jdbcType=" + this.jdbcType + '}';
        }
    }
}

