/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.po;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.Map;

public class TableField {
    private boolean convert;
    private boolean keyFlag;
    private boolean keyIdentityFlag;
    private String name;
    private String type;
    private String propertyName;
    private IColumnType columnType;
    private String comment;
    private String fill;
    private boolean keyWords;
    private String columnName;
    private Map<String, Object> customMap;

    public TableField setConvert(boolean convert) {
        this.convert = convert;
        return this;
    }

    protected TableField setConvert(StrategyConfig strategyConfig) {
        if (strategyConfig.isEntityTableFieldAnnotationEnable() || this.isKeyWords()) {
            this.convert = true;
            return this;
        }
        if (strategyConfig.isCapitalModeNaming(this.name)) {
            this.convert = false;
        } else if (NamingStrategy.underline_to_camel == strategyConfig.getColumnNaming()) {
            if (StringUtils.containsUpperCase((String)this.name)) {
                this.convert = true;
            }
        } else if (!this.name.equals(this.propertyName)) {
            this.convert = true;
        }
        return this;
    }

    public TableField setPropertyName(StrategyConfig strategyConfig, String propertyName) {
        this.propertyName = propertyName;
        this.setConvert(strategyConfig);
        return this;
    }

    public String getPropertyType() {
        if (null != this.columnType) {
            return this.columnType.getType();
        }
        return null;
    }

    public String getCapitalName() {
        if (this.propertyName.length() == 1) {
            return this.propertyName.toUpperCase();
        }
        if (Character.isLowerCase(this.propertyName.charAt(1))) {
            return Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
        }
        return this.propertyName;
    }

    public String getAnnotationColumnName() {
        if (this.keyWords && this.columnName.startsWith("\"")) {
            return String.format("\\\"%s\\\"", this.name);
        }
        return this.columnName;
    }

    public boolean isConvert() {
        return this.convert;
    }

    public boolean isKeyFlag() {
        return this.keyFlag;
    }

    public boolean isKeyIdentityFlag() {
        return this.keyIdentityFlag;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public IColumnType getColumnType() {
        return this.columnType;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFill() {
        return this.fill;
    }

    public boolean isKeyWords() {
        return this.keyWords;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Map<String, Object> getCustomMap() {
        return this.customMap;
    }

    public TableField setKeyFlag(boolean keyFlag) {
        this.keyFlag = keyFlag;
        return this;
    }

    public TableField setKeyIdentityFlag(boolean keyIdentityFlag) {
        this.keyIdentityFlag = keyIdentityFlag;
        return this;
    }

    public TableField setName(String name) {
        this.name = name;
        return this;
    }

    public TableField setType(String type) {
        this.type = type;
        return this;
    }

    public TableField setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public TableField setColumnType(IColumnType columnType) {
        this.columnType = columnType;
        return this;
    }

    public TableField setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public TableField setFill(String fill) {
        this.fill = fill;
        return this;
    }

    public TableField setKeyWords(boolean keyWords) {
        this.keyWords = keyWords;
        return this;
    }

    public TableField setColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public TableField setCustomMap(Map<String, Object> customMap) {
        this.customMap = customMap;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableField)) {
            return false;
        }
        TableField other = (TableField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isConvert() != other.isConvert()) {
            return false;
        }
        if (this.isKeyFlag() != other.isKeyFlag()) {
            return false;
        }
        if (this.isKeyIdentityFlag() != other.isKeyIdentityFlag()) {
            return false;
        }
        if (this.isKeyWords() != other.isKeyWords()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        IColumnType this$columnType = this.getColumnType();
        IColumnType other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$fill = this.getFill();
        String other$fill = other.getFill();
        if (this$fill == null ? other$fill != null : !this$fill.equals(other$fill)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        Map<String, Object> this$customMap = this.getCustomMap();
        Map<String, Object> other$customMap = other.getCustomMap();
        return !(this$customMap == null ? other$customMap != null : !((Object)this$customMap).equals(other$customMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConvert() ? 79 : 97);
        result = result * 59 + (this.isKeyFlag() ? 79 : 97);
        result = result * 59 + (this.isKeyIdentityFlag() ? 79 : 97);
        result = result * 59 + (this.isKeyWords() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        IColumnType $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $fill = this.getFill();
        result = result * 59 + ($fill == null ? 43 : $fill.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        Map<String, Object> $customMap = this.getCustomMap();
        result = result * 59 + ($customMap == null ? 43 : ((Object)$customMap).hashCode());
        return result;
    }

    public String toString() {
        return "TableField(convert=" + this.isConvert() + ", keyFlag=" + this.isKeyFlag() + ", keyIdentityFlag=" + this.isKeyIdentityFlag() + ", name=" + this.getName() + ", type=" + this.getType() + ", propertyName=" + this.getPropertyName() + ", columnType=" + this.getColumnType() + ", comment=" + this.getComment() + ", fill=" + this.getFill() + ", keyWords=" + this.isKeyWords() + ", columnName=" + this.getColumnName() + ", customMap=" + this.getCustomMap() + ")";
    }
}

