/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.po.LikeTable;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class StrategyConfig {
    private boolean isCapitalMode = false;
    private boolean skipView = false;
    private INameConvert nameConvert;
    private NamingStrategy naming = NamingStrategy.no_change;
    private NamingStrategy columnNaming = null;
    private final Set<String> tablePrefix = new HashSet<String>();
    private final Set<String> fieldPrefix = new HashSet<String>();
    private String superEntityClass;
    private final Set<String> superEntityColumns = new HashSet<String>();
    private String superMapperClass = "com.baomidou.mybatisplus.core.mapper.BaseMapper";
    private String superServiceClass = "com.baomidou.mybatisplus.extension.service.IService";
    private String superServiceImplClass = "com.baomidou.mybatisplus.extension.service.impl.ServiceImpl";
    private String superControllerClass;
    private final Set<String> include = new HashSet<String>();
    private final Set<String> exclude = new HashSet<String>();
    private boolean entitySerialVersionUID = true;
    private boolean entityColumnConstant = false;
    @Deprecated
    private boolean entityBuilderModel = false;
    private boolean chainModel = false;
    private boolean entityLombokModel = false;
    private boolean entityBooleanColumnRemoveIsPrefix = false;
    private boolean restControllerStyle = false;
    private boolean controllerMappingHyphenStyle = false;
    private boolean entityTableFieldAnnotationEnable = false;
    private String versionFieldName;
    private String logicDeleteFieldName;
    private List<TableFill> tableFillList = null;
    private boolean enableSqlFilter = true;
    private LikeTable likeTable;
    private LikeTable notLikeTable;

    public boolean isCapitalModeNaming(String word) {
        return this.isCapitalMode && StringUtils.isCapitalMode((String)word);
    }

    @Deprecated
    public boolean containsTablePrefix(String tableName) {
        return this.getTablePrefix().stream().anyMatch(tableName::contains);
    }

    public boolean startsWithTablePrefix(String tableName) {
        return this.getTablePrefix().stream().anyMatch(tableName::startsWith);
    }

    public NamingStrategy getColumnNaming() {
        return Optional.ofNullable(this.columnNaming).orElse(this.naming);
    }

    public StrategyConfig setTablePrefix(String ... tablePrefix) {
        this.tablePrefix.addAll(Arrays.asList(tablePrefix));
        return this;
    }

    public boolean includeSuperEntityColumns(String fieldName) {
        return this.superEntityColumns.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName));
    }

    public StrategyConfig setSuperEntityColumns(String ... superEntityColumns) {
        this.superEntityColumns.addAll(Arrays.asList(superEntityColumns));
        return this;
    }

    public StrategyConfig setInclude(String ... include) {
        this.include.addAll(Arrays.asList(include));
        return this;
    }

    public StrategyConfig setExclude(String ... exclude) {
        this.exclude.addAll(Arrays.asList(exclude));
        return this;
    }

    public StrategyConfig setFieldPrefix(String ... fieldPrefixs) {
        this.fieldPrefix.addAll(Arrays.asList(fieldPrefixs));
        return this;
    }

    public StrategyConfig setSuperEntityClass(String superEntityClass) {
        this.superEntityClass = superEntityClass;
        return this;
    }

    public StrategyConfig setSuperEntityClass(Class<?> clazz) {
        this.superEntityClass = clazz.getName();
        return this;
    }

    public StrategyConfig setSuperEntityClass(Class<?> clazz, NamingStrategy columnNaming) {
        this.columnNaming = columnNaming;
        this.superEntityClass = clazz.getName();
        return this;
    }

    public StrategyConfig setSuperServiceClass(Class<?> clazz) {
        this.superServiceClass = clazz.getName();
        return this;
    }

    public StrategyConfig setSuperServiceClass(String superServiceClass) {
        this.superServiceClass = superServiceClass;
        return this;
    }

    public StrategyConfig setSuperServiceImplClass(Class<?> clazz) {
        this.superServiceImplClass = clazz.getName();
        return this;
    }

    public StrategyConfig setSuperServiceImplClass(String superServiceImplClass) {
        this.superServiceImplClass = superServiceImplClass;
        return this;
    }

    public StrategyConfig setSuperControllerClass(Class<?> clazz) {
        this.superControllerClass = clazz.getName();
        return this;
    }

    public StrategyConfig setSuperControllerClass(String superControllerClass) {
        this.superControllerClass = superControllerClass;
        return this;
    }

    protected void convertSuperEntityColumns(Class<?> clazz) {
        List fields = TableInfoHelper.getAllFields(clazz);
        this.superEntityColumns.addAll(fields.stream().map(field -> {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId != null && StringUtils.isNotBlank((CharSequence)tableId.value())) {
                return tableId.value();
            }
            TableField tableField = field.getAnnotation(TableField.class);
            if (tableField != null && StringUtils.isNotBlank((CharSequence)tableField.value())) {
                return tableField.value();
            }
            if (null == this.columnNaming || this.columnNaming == NamingStrategy.no_change) {
                return field.getName();
            }
            return StringUtils.camelToUnderline((String)field.getName());
        }).collect(Collectors.toSet()));
    }

    @Deprecated
    public boolean isEntityBuilderModel() {
        return this.isChainModel();
    }

    @Deprecated
    public StrategyConfig setEntityBuilderModel(boolean entityBuilderModel) {
        return this.setChainModel(entityBuilderModel);
    }

    public Set<String> getSuperEntityColumns() {
        if (StringUtils.isNotBlank((CharSequence)this.superEntityClass)) {
            try {
                Class superEntity = ClassUtils.toClassConfident((String)this.superEntityClass);
                this.convertSuperEntityColumns(superEntity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.superEntityColumns;
    }

    public boolean isCapitalMode() {
        return this.isCapitalMode;
    }

    public boolean isSkipView() {
        return this.skipView;
    }

    public INameConvert getNameConvert() {
        return this.nameConvert;
    }

    public NamingStrategy getNaming() {
        return this.naming;
    }

    public Set<String> getTablePrefix() {
        return this.tablePrefix;
    }

    public Set<String> getFieldPrefix() {
        return this.fieldPrefix;
    }

    public String getSuperEntityClass() {
        return this.superEntityClass;
    }

    public String getSuperMapperClass() {
        return this.superMapperClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public Set<String> getInclude() {
        return this.include;
    }

    public Set<String> getExclude() {
        return this.exclude;
    }

    public boolean isEntitySerialVersionUID() {
        return this.entitySerialVersionUID;
    }

    public boolean isEntityColumnConstant() {
        return this.entityColumnConstant;
    }

    public boolean isChainModel() {
        return this.chainModel;
    }

    public boolean isEntityLombokModel() {
        return this.entityLombokModel;
    }

    public boolean isEntityBooleanColumnRemoveIsPrefix() {
        return this.entityBooleanColumnRemoveIsPrefix;
    }

    public boolean isRestControllerStyle() {
        return this.restControllerStyle;
    }

    public boolean isControllerMappingHyphenStyle() {
        return this.controllerMappingHyphenStyle;
    }

    public boolean isEntityTableFieldAnnotationEnable() {
        return this.entityTableFieldAnnotationEnable;
    }

    public String getVersionFieldName() {
        return this.versionFieldName;
    }

    public String getLogicDeleteFieldName() {
        return this.logicDeleteFieldName;
    }

    public List<TableFill> getTableFillList() {
        return this.tableFillList;
    }

    public boolean isEnableSqlFilter() {
        return this.enableSqlFilter;
    }

    public LikeTable getLikeTable() {
        return this.likeTable;
    }

    public LikeTable getNotLikeTable() {
        return this.notLikeTable;
    }

    public StrategyConfig setCapitalMode(boolean isCapitalMode) {
        this.isCapitalMode = isCapitalMode;
        return this;
    }

    public StrategyConfig setSkipView(boolean skipView) {
        this.skipView = skipView;
        return this;
    }

    public StrategyConfig setNameConvert(INameConvert nameConvert) {
        this.nameConvert = nameConvert;
        return this;
    }

    public StrategyConfig setNaming(NamingStrategy naming) {
        this.naming = naming;
        return this;
    }

    public StrategyConfig setColumnNaming(NamingStrategy columnNaming) {
        this.columnNaming = columnNaming;
        return this;
    }

    public StrategyConfig setSuperMapperClass(String superMapperClass) {
        this.superMapperClass = superMapperClass;
        return this;
    }

    public StrategyConfig setEntitySerialVersionUID(boolean entitySerialVersionUID) {
        this.entitySerialVersionUID = entitySerialVersionUID;
        return this;
    }

    public StrategyConfig setEntityColumnConstant(boolean entityColumnConstant) {
        this.entityColumnConstant = entityColumnConstant;
        return this;
    }

    public StrategyConfig setChainModel(boolean chainModel) {
        this.chainModel = chainModel;
        return this;
    }

    public StrategyConfig setEntityLombokModel(boolean entityLombokModel) {
        this.entityLombokModel = entityLombokModel;
        return this;
    }

    public StrategyConfig setEntityBooleanColumnRemoveIsPrefix(boolean entityBooleanColumnRemoveIsPrefix) {
        this.entityBooleanColumnRemoveIsPrefix = entityBooleanColumnRemoveIsPrefix;
        return this;
    }

    public StrategyConfig setRestControllerStyle(boolean restControllerStyle) {
        this.restControllerStyle = restControllerStyle;
        return this;
    }

    public StrategyConfig setControllerMappingHyphenStyle(boolean controllerMappingHyphenStyle) {
        this.controllerMappingHyphenStyle = controllerMappingHyphenStyle;
        return this;
    }

    public StrategyConfig setEntityTableFieldAnnotationEnable(boolean entityTableFieldAnnotationEnable) {
        this.entityTableFieldAnnotationEnable = entityTableFieldAnnotationEnable;
        return this;
    }

    public StrategyConfig setVersionFieldName(String versionFieldName) {
        this.versionFieldName = versionFieldName;
        return this;
    }

    public StrategyConfig setLogicDeleteFieldName(String logicDeleteFieldName) {
        this.logicDeleteFieldName = logicDeleteFieldName;
        return this;
    }

    public StrategyConfig setTableFillList(List<TableFill> tableFillList) {
        this.tableFillList = tableFillList;
        return this;
    }

    public StrategyConfig setEnableSqlFilter(boolean enableSqlFilter) {
        this.enableSqlFilter = enableSqlFilter;
        return this;
    }

    public StrategyConfig setLikeTable(LikeTable likeTable) {
        this.likeTable = likeTable;
        return this;
    }

    public StrategyConfig setNotLikeTable(LikeTable notLikeTable) {
        this.notLikeTable = notLikeTable;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrategyConfig)) {
            return false;
        }
        StrategyConfig other = (StrategyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCapitalMode() != other.isCapitalMode()) {
            return false;
        }
        if (this.isSkipView() != other.isSkipView()) {
            return false;
        }
        if (this.isEntitySerialVersionUID() != other.isEntitySerialVersionUID()) {
            return false;
        }
        if (this.isEntityColumnConstant() != other.isEntityColumnConstant()) {
            return false;
        }
        if (this.isEntityBuilderModel() != other.isEntityBuilderModel()) {
            return false;
        }
        if (this.isChainModel() != other.isChainModel()) {
            return false;
        }
        if (this.isEntityLombokModel() != other.isEntityLombokModel()) {
            return false;
        }
        if (this.isEntityBooleanColumnRemoveIsPrefix() != other.isEntityBooleanColumnRemoveIsPrefix()) {
            return false;
        }
        if (this.isRestControllerStyle() != other.isRestControllerStyle()) {
            return false;
        }
        if (this.isControllerMappingHyphenStyle() != other.isControllerMappingHyphenStyle()) {
            return false;
        }
        if (this.isEntityTableFieldAnnotationEnable() != other.isEntityTableFieldAnnotationEnable()) {
            return false;
        }
        if (this.isEnableSqlFilter() != other.isEnableSqlFilter()) {
            return false;
        }
        INameConvert this$nameConvert = this.getNameConvert();
        INameConvert other$nameConvert = other.getNameConvert();
        if (this$nameConvert == null ? other$nameConvert != null : !this$nameConvert.equals(other$nameConvert)) {
            return false;
        }
        NamingStrategy this$naming = this.getNaming();
        NamingStrategy other$naming = other.getNaming();
        if (this$naming == null ? other$naming != null : !((Object)((Object)this$naming)).equals((Object)other$naming)) {
            return false;
        }
        NamingStrategy this$columnNaming = this.getColumnNaming();
        NamingStrategy other$columnNaming = other.getColumnNaming();
        if (this$columnNaming == null ? other$columnNaming != null : !((Object)((Object)this$columnNaming)).equals((Object)other$columnNaming)) {
            return false;
        }
        Set<String> this$tablePrefix = this.getTablePrefix();
        Set<String> other$tablePrefix = other.getTablePrefix();
        if (this$tablePrefix == null ? other$tablePrefix != null : !((Object)this$tablePrefix).equals(other$tablePrefix)) {
            return false;
        }
        Set<String> this$fieldPrefix = this.getFieldPrefix();
        Set<String> other$fieldPrefix = other.getFieldPrefix();
        if (this$fieldPrefix == null ? other$fieldPrefix != null : !((Object)this$fieldPrefix).equals(other$fieldPrefix)) {
            return false;
        }
        String this$superEntityClass = this.getSuperEntityClass();
        String other$superEntityClass = other.getSuperEntityClass();
        if (this$superEntityClass == null ? other$superEntityClass != null : !this$superEntityClass.equals(other$superEntityClass)) {
            return false;
        }
        Set<String> this$superEntityColumns = this.getSuperEntityColumns();
        Set<String> other$superEntityColumns = other.getSuperEntityColumns();
        if (this$superEntityColumns == null ? other$superEntityColumns != null : !((Object)this$superEntityColumns).equals(other$superEntityColumns)) {
            return false;
        }
        String this$superMapperClass = this.getSuperMapperClass();
        String other$superMapperClass = other.getSuperMapperClass();
        if (this$superMapperClass == null ? other$superMapperClass != null : !this$superMapperClass.equals(other$superMapperClass)) {
            return false;
        }
        String this$superServiceClass = this.getSuperServiceClass();
        String other$superServiceClass = other.getSuperServiceClass();
        if (this$superServiceClass == null ? other$superServiceClass != null : !this$superServiceClass.equals(other$superServiceClass)) {
            return false;
        }
        String this$superServiceImplClass = this.getSuperServiceImplClass();
        String other$superServiceImplClass = other.getSuperServiceImplClass();
        if (this$superServiceImplClass == null ? other$superServiceImplClass != null : !this$superServiceImplClass.equals(other$superServiceImplClass)) {
            return false;
        }
        String this$superControllerClass = this.getSuperControllerClass();
        String other$superControllerClass = other.getSuperControllerClass();
        if (this$superControllerClass == null ? other$superControllerClass != null : !this$superControllerClass.equals(other$superControllerClass)) {
            return false;
        }
        Set<String> this$include = this.getInclude();
        Set<String> other$include = other.getInclude();
        if (this$include == null ? other$include != null : !((Object)this$include).equals(other$include)) {
            return false;
        }
        Set<String> this$exclude = this.getExclude();
        Set<String> other$exclude = other.getExclude();
        if (this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude)) {
            return false;
        }
        String this$versionFieldName = this.getVersionFieldName();
        String other$versionFieldName = other.getVersionFieldName();
        if (this$versionFieldName == null ? other$versionFieldName != null : !this$versionFieldName.equals(other$versionFieldName)) {
            return false;
        }
        String this$logicDeleteFieldName = this.getLogicDeleteFieldName();
        String other$logicDeleteFieldName = other.getLogicDeleteFieldName();
        if (this$logicDeleteFieldName == null ? other$logicDeleteFieldName != null : !this$logicDeleteFieldName.equals(other$logicDeleteFieldName)) {
            return false;
        }
        List<TableFill> this$tableFillList = this.getTableFillList();
        List<TableFill> other$tableFillList = other.getTableFillList();
        if (this$tableFillList == null ? other$tableFillList != null : !((Object)this$tableFillList).equals(other$tableFillList)) {
            return false;
        }
        LikeTable this$likeTable = this.getLikeTable();
        LikeTable other$likeTable = other.getLikeTable();
        if (this$likeTable == null ? other$likeTable != null : !this$likeTable.equals(other$likeTable)) {
            return false;
        }
        LikeTable this$notLikeTable = this.getNotLikeTable();
        LikeTable other$notLikeTable = other.getNotLikeTable();
        return !(this$notLikeTable == null ? other$notLikeTable != null : !this$notLikeTable.equals(other$notLikeTable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StrategyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCapitalMode() ? 79 : 97);
        result = result * 59 + (this.isSkipView() ? 79 : 97);
        result = result * 59 + (this.isEntitySerialVersionUID() ? 79 : 97);
        result = result * 59 + (this.isEntityColumnConstant() ? 79 : 97);
        result = result * 59 + (this.isEntityBuilderModel() ? 79 : 97);
        result = result * 59 + (this.isChainModel() ? 79 : 97);
        result = result * 59 + (this.isEntityLombokModel() ? 79 : 97);
        result = result * 59 + (this.isEntityBooleanColumnRemoveIsPrefix() ? 79 : 97);
        result = result * 59 + (this.isRestControllerStyle() ? 79 : 97);
        result = result * 59 + (this.isControllerMappingHyphenStyle() ? 79 : 97);
        result = result * 59 + (this.isEntityTableFieldAnnotationEnable() ? 79 : 97);
        result = result * 59 + (this.isEnableSqlFilter() ? 79 : 97);
        INameConvert $nameConvert = this.getNameConvert();
        result = result * 59 + ($nameConvert == null ? 43 : $nameConvert.hashCode());
        NamingStrategy $naming = this.getNaming();
        result = result * 59 + ($naming == null ? 43 : ((Object)((Object)$naming)).hashCode());
        NamingStrategy $columnNaming = this.getColumnNaming();
        result = result * 59 + ($columnNaming == null ? 43 : ((Object)((Object)$columnNaming)).hashCode());
        Set<String> $tablePrefix = this.getTablePrefix();
        result = result * 59 + ($tablePrefix == null ? 43 : ((Object)$tablePrefix).hashCode());
        Set<String> $fieldPrefix = this.getFieldPrefix();
        result = result * 59 + ($fieldPrefix == null ? 43 : ((Object)$fieldPrefix).hashCode());
        String $superEntityClass = this.getSuperEntityClass();
        result = result * 59 + ($superEntityClass == null ? 43 : $superEntityClass.hashCode());
        Set<String> $superEntityColumns = this.getSuperEntityColumns();
        result = result * 59 + ($superEntityColumns == null ? 43 : ((Object)$superEntityColumns).hashCode());
        String $superMapperClass = this.getSuperMapperClass();
        result = result * 59 + ($superMapperClass == null ? 43 : $superMapperClass.hashCode());
        String $superServiceClass = this.getSuperServiceClass();
        result = result * 59 + ($superServiceClass == null ? 43 : $superServiceClass.hashCode());
        String $superServiceImplClass = this.getSuperServiceImplClass();
        result = result * 59 + ($superServiceImplClass == null ? 43 : $superServiceImplClass.hashCode());
        String $superControllerClass = this.getSuperControllerClass();
        result = result * 59 + ($superControllerClass == null ? 43 : $superControllerClass.hashCode());
        Set<String> $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : ((Object)$include).hashCode());
        Set<String> $exclude = this.getExclude();
        result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
        String $versionFieldName = this.getVersionFieldName();
        result = result * 59 + ($versionFieldName == null ? 43 : $versionFieldName.hashCode());
        String $logicDeleteFieldName = this.getLogicDeleteFieldName();
        result = result * 59 + ($logicDeleteFieldName == null ? 43 : $logicDeleteFieldName.hashCode());
        List<TableFill> $tableFillList = this.getTableFillList();
        result = result * 59 + ($tableFillList == null ? 43 : ((Object)$tableFillList).hashCode());
        LikeTable $likeTable = this.getLikeTable();
        result = result * 59 + ($likeTable == null ? 43 : $likeTable.hashCode());
        LikeTable $notLikeTable = this.getNotLikeTable();
        result = result * 59 + ($notLikeTable == null ? 43 : $notLikeTable.hashCode());
        return result;
    }

    public String toString() {
        return "StrategyConfig(isCapitalMode=" + this.isCapitalMode() + ", skipView=" + this.isSkipView() + ", nameConvert=" + this.getNameConvert() + ", naming=" + (Object)((Object)this.getNaming()) + ", columnNaming=" + (Object)((Object)this.getColumnNaming()) + ", tablePrefix=" + this.getTablePrefix() + ", fieldPrefix=" + this.getFieldPrefix() + ", superEntityClass=" + this.getSuperEntityClass() + ", superEntityColumns=" + this.getSuperEntityColumns() + ", superMapperClass=" + this.getSuperMapperClass() + ", superServiceClass=" + this.getSuperServiceClass() + ", superServiceImplClass=" + this.getSuperServiceImplClass() + ", superControllerClass=" + this.getSuperControllerClass() + ", include=" + this.getInclude() + ", exclude=" + this.getExclude() + ", entitySerialVersionUID=" + this.isEntitySerialVersionUID() + ", entityColumnConstant=" + this.isEntityColumnConstant() + ", entityBuilderModel=" + this.isEntityBuilderModel() + ", chainModel=" + this.isChainModel() + ", entityLombokModel=" + this.isEntityLombokModel() + ", entityBooleanColumnRemoveIsPrefix=" + this.isEntityBooleanColumnRemoveIsPrefix() + ", restControllerStyle=" + this.isRestControllerStyle() + ", controllerMappingHyphenStyle=" + this.isControllerMappingHyphenStyle() + ", entityTableFieldAnnotationEnable=" + this.isEntityTableFieldAnnotationEnable() + ", versionFieldName=" + this.getVersionFieldName() + ", logicDeleteFieldName=" + this.getLogicDeleteFieldName() + ", tableFillList=" + this.getTableFillList() + ", enableSqlFilter=" + this.isEnableSqlFilter() + ", likeTable=" + this.getLikeTable() + ", notLikeTable=" + this.getNotLikeTable() + ")";
    }
}

