/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;

public class SqliteTypeConvert
implements ITypeConvert {
    @Override
    public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("bigint")) {
            return DbColumnType.LONG;
        }
        if (t.contains("tinyint(1)") || t.contains("boolean")) {
            return DbColumnType.BOOLEAN;
        }
        if (t.contains("int")) {
            return DbColumnType.INTEGER;
        }
        if (t.contains("text") || t.contains("char") || t.contains("enum")) {
            return DbColumnType.STRING;
        }
        if (t.contains("decimal") || t.contains("numeric")) {
            return DbColumnType.BIG_DECIMAL;
        }
        if (t.contains("clob")) {
            return DbColumnType.CLOB;
        }
        if (t.contains("blob")) {
            return DbColumnType.BLOB;
        }
        if (t.contains("float")) {
            return DbColumnType.FLOAT;
        }
        if (t.contains("double")) {
            return DbColumnType.DOUBLE;
        }
        if (t.contains("date") || t.contains("time") || t.contains("year")) {
            switch (globalConfig.getDateType()) {
                case ONLY_DATE: {
                    return DbColumnType.DATE;
                }
                case SQL_PACK: {
                    switch (t) {
                        case "date": {
                            return DbColumnType.DATE_SQL;
                        }
                        case "time": {
                            return DbColumnType.TIME;
                        }
                        case "year": {
                            return DbColumnType.DATE_SQL;
                        }
                    }
                    return DbColumnType.TIMESTAMP;
                }
                case TIME_PACK: {
                    switch (t) {
                        case "date": {
                            return DbColumnType.LOCAL_DATE;
                        }
                        case "time": {
                            return DbColumnType.LOCAL_TIME;
                        }
                        case "year": {
                            return DbColumnType.YEAR;
                        }
                    }
                    return DbColumnType.LOCAL_DATE_TIME;
                }
            }
        }
        return DbColumnType.STRING;
    }
}

