/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;

public class PostgreSqlTypeConvert
implements ITypeConvert {
    @Override
    public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("char")) {
            return DbColumnType.STRING;
        }
        if (t.contains("bigint")) {
            return DbColumnType.LONG;
        }
        if (t.contains("int")) {
            return DbColumnType.INTEGER;
        }
        if (t.contains("date") || t.contains("time")) {
            switch (globalConfig.getDateType()) {
                case ONLY_DATE: {
                    return DbColumnType.DATE;
                }
                case SQL_PACK: {
                    switch (t) {
                        case "date": {
                            return DbColumnType.DATE_SQL;
                        }
                        case "time": {
                            return DbColumnType.TIME;
                        }
                    }
                    return DbColumnType.TIMESTAMP;
                }
                case TIME_PACK: {
                    switch (t) {
                        case "date": {
                            return DbColumnType.LOCAL_DATE;
                        }
                        case "time": {
                            return DbColumnType.LOCAL_TIME;
                        }
                    }
                    return DbColumnType.LOCAL_DATE_TIME;
                }
            }
            return DbColumnType.DATE;
        }
        if (t.contains("text")) {
            return DbColumnType.STRING;
        }
        if (t.contains("bit")) {
            return DbColumnType.BOOLEAN;
        }
        if (t.contains("decimal")) {
            return DbColumnType.BIG_DECIMAL;
        }
        if (t.contains("clob")) {
            return DbColumnType.CLOB;
        }
        if (t.contains("blob")) {
            return DbColumnType.BYTE_ARRAY;
        }
        if (t.contains("float")) {
            return DbColumnType.FLOAT;
        }
        if (t.contains("double")) {
            return DbColumnType.DOUBLE;
        }
        if (t.contains("json") || t.contains("enum")) {
            return DbColumnType.STRING;
        }
        if (t.contains("boolean")) {
            return DbColumnType.BOOLEAN;
        }
        return DbColumnType.STRING;
    }
}

