/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.sql;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlFormatter;

public class SqlUtils {
    private static final SqlFormatter SQL_FORMATTER = new SqlFormatter();

    public static String sqlFormat(String boundSql, boolean format) {
        if (format) {
            try {
                return SQL_FORMATTER.format(boundSql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boundSql;
    }

    public static String concatLike(String str, SqlLike type) {
        StringBuilder builder = new StringBuilder(str.length() + 3);
        switch (type) {
            case LEFT: {
                builder.append("%").append(str);
                break;
            }
            case RIGHT: {
                builder.append(str).append("%");
                break;
            }
            case CUSTOM: {
                builder.append(str);
                break;
            }
            default: {
                builder.append("%").append(str).append("%");
            }
        }
        return builder.toString();
    }

    public static String sqlWordConvert(DbType dbType, String val, boolean isColumn) {
        if (dbType == DbType.POSTGRE_SQL) {
            if (isColumn && (StringUtils.isNotColumnName(val) || val.toLowerCase().equals(val))) {
                return val;
            }
            return String.format("\"%s\"", val);
        }
        return val;
    }

    public static String stripSqlInjection(String sql) {
        Assert.notNull(sql, "strip sql is null.");
        return sql.replaceAll("('.+--)|(--)|(\\|)|(%7C)", "");
    }
}

