/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.annotations.Version;
import com.baomidou.mybatisplus.entity.TableFieldInfo;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.EntityField;
import com.baomidou.mybatisplus.toolkit.ClassUtils;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OptimisticLockerInterceptor
implements Interceptor {
    private final Map<Class<?>, EntityField> versionFieldCache = new ConcurrentHashMap();
    private final Map<Class<?>, List<EntityField>> entityFieldsCache = new ConcurrentHashMap();
    private static final String MP_OPTLOCK_VERSION_ORIGINAL = "MP_OPTLOCK_VERSION_ORIGINAL";
    private static final String MP_OPTLOCK_VERSION_COLUMN = "MP_OPTLOCK_VERSION_COLUMN";
    public static final String MP_OPTLOCK_ET_ORIGINAL = "MP_OPTLOCK_ET_ORIGINAL";
    private static final String NAME_ENTITY = "et";
    private static final String NAME_ENTITY_WRAPPER = "ew";
    private static final String PARAM_UPDATE_METHOD_NAME = "update";

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (SqlCommandType.UPDATE != ms.getSqlCommandType()) {
            return invocation.proceed();
        }
        Object param = args[1];
        if (param instanceof HashMap) {
            HashMap map = (HashMap)param;
            Wrapper ew = null;
            if (map.containsKey(NAME_ENTITY_WRAPPER)) {
                ew = (Wrapper)map.get(NAME_ENTITY_WRAPPER);
            }
            Object et = null;
            if (map.containsKey(NAME_ENTITY)) {
                et = map.get(NAME_ENTITY);
            }
            if (ew != null) {
                Object entity = ew.getEntity();
                if (entity != null) {
                    Object originalVersionVal;
                    Field versionField;
                    Class entityClass = ClassUtils.getUserClass(entity.getClass());
                    EntityField ef = this.getVersionField(entityClass);
                    Field field = versionField = ef == null ? null : ef.getField();
                    if (versionField != null && (originalVersionVal = versionField.get(entity)) != null) {
                        versionField.set(et, this.getUpdatedVersionVal(originalVersionVal));
                    }
                }
            } else if (et != null) {
                Object originalVersionVal;
                Field versionField;
                String methodId = ms.getId();
                String updateMethodName = methodId.substring(ms.getId().lastIndexOf(".") + 1);
                if (PARAM_UPDATE_METHOD_NAME.equals(updateMethodName)) {
                    return invocation.proceed();
                }
                Class entityClass = ClassUtils.getUserClass(et.getClass());
                EntityField entityField = this.getVersionField(entityClass);
                Field field = versionField = entityField == null ? null : entityField.getField();
                if (versionField != null && (originalVersionVal = versionField.get(et)) != null) {
                    TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)entityClass);
                    while (null == tableInfo && null != entityClass) {
                        entityClass = ClassUtils.getUserClass(entityClass.getSuperclass());
                        tableInfo = TableInfoHelper.getTableInfo((Class)entityClass);
                    }
                    HashMap<String, Object> entityMap = new HashMap<String, Object>();
                    List<EntityField> fields = this.getEntityFields(entityClass);
                    for (EntityField ef : fields) {
                        Field fd = ef.getField();
                        if (!fd.isAccessible()) continue;
                        entityMap.put(fd.getName(), fd.get(et));
                        if (!ef.isVersion()) continue;
                        versionField = fd;
                    }
                    String versionPropertyName = versionField.getName();
                    List fieldList = tableInfo.getFieldList();
                    String versionColumnName = entityField.getColumnName();
                    if (versionColumnName == null) {
                        for (TableFieldInfo tf : fieldList) {
                            if (!versionPropertyName.equals(tf.getProperty())) continue;
                            versionColumnName = tf.getColumn();
                        }
                    }
                    if (versionColumnName != null) {
                        entityField.setColumnName(versionColumnName);
                        entityMap.put(versionField.getName(), this.getUpdatedVersionVal(originalVersionVal));
                        entityMap.put(MP_OPTLOCK_VERSION_ORIGINAL, originalVersionVal);
                        entityMap.put(MP_OPTLOCK_VERSION_COLUMN, versionColumnName);
                        entityMap.put(MP_OPTLOCK_ET_ORIGINAL, et);
                        map.put(NAME_ENTITY, entityMap);
                    }
                }
            }
        }
        return invocation.proceed();
    }

    protected Object getUpdatedVersionVal(Object originalVersionVal) {
        Class<?> versionValClass = originalVersionVal.getClass();
        if (Long.TYPE.equals(versionValClass)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Long.class.equals(versionValClass)) {
            return (Long)originalVersionVal + 1L;
        }
        if (Integer.TYPE.equals(versionValClass)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Integer.class.equals(versionValClass)) {
            return (Integer)originalVersionVal + 1;
        }
        if (Date.class.equals(versionValClass)) {
            return new Date();
        }
        if (Timestamp.class.equals(versionValClass)) {
            return new Timestamp(System.currentTimeMillis());
        }
        return originalVersionVal;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityField getVersionField(Class<?> parameterClass) {
        String string = parameterClass.getName();
        synchronized (string) {
            if (this.versionFieldCache.containsKey(parameterClass)) {
                return this.versionFieldCache.get(parameterClass);
            }
            EntityField field = this.getVersionFieldRegular(parameterClass);
            if (field != null) {
                this.versionFieldCache.put(parameterClass, field);
                return field;
            }
            return null;
        }
    }

    private EntityField getVersionFieldRegular(Class<?> parameterClass) {
        if (parameterClass != Object.class) {
            for (Field field : parameterClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Version.class)) continue;
                field.setAccessible(true);
                return new EntityField(field, true);
            }
            return this.getVersionFieldRegular(parameterClass.getSuperclass());
        }
        return null;
    }

    private List<EntityField> getEntityFields(Class<?> parameterClass) {
        if (this.entityFieldsCache.containsKey(parameterClass)) {
            return this.entityFieldsCache.get(parameterClass);
        }
        List<EntityField> fields = this.getFieldsFromClazz(parameterClass, null);
        this.entityFieldsCache.put(parameterClass, fields);
        return fields;
    }

    private List<EntityField> getFieldsFromClazz(Class<?> parameterClass, List<EntityField> fieldList) {
        if (fieldList == null) {
            fieldList = new ArrayList<EntityField>();
        }
        List fields = ReflectionKit.getFieldList(parameterClass);
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(Version.class)) {
                fieldList.add(new EntityField(field, true));
                continue;
            }
            fieldList.add(new EntityField(field, false));
        }
        return fieldList;
    }
}

