/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock.executor;

import com.baomidou.lock.exception.LockException;
import com.baomidou.lock.executor.AbstractLockExecutor;
import com.baomidou.lock.spring.boot.autoconfigure.Lock4jProperties;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisTemplateLockExecutor
extends AbstractLockExecutor<String> {
    private static final Logger log = LoggerFactory.getLogger(RedisTemplateLockExecutor.class);
    private static final RedisScript<String> SCRIPT_LOCK = new DefaultRedisScript("return redis.call('set',KEYS[1],ARGV[1],'NX','PX',ARGV[2])", String.class);
    private static final RedisScript<String> SCRIPT_UNLOCK = new DefaultRedisScript("if redis.call('get',KEYS[1]) == ARGV[1] then return tostring(redis.call('del', KEYS[1])==1) else return 'false' end", String.class);
    private static final RedisScript<Boolean> SCRIPT_RENEWAL = new DefaultRedisScript("if redis.call('get', KEYS[1]) ==ARGV[1] then return redis.call('pexpire', KEYS[1], ARGV[2]) else  return 0  end", Boolean.class);
    private static final String LOCK_SUCCESS = "OK";
    private final StringRedisTemplate redisTemplate;
    private final Lock4jProperties lock4jProperties;

    public boolean renewal() {
        return true;
    }

    public String acquire(String lockKey, String lockValue, long expire, long acquireTimeout) {
        String lock;
        long newExpire = expire > 0L ? expire : this.lock4jProperties.getExpire();
        CompletionStage cf = CompletableFuture.supplyAsync(() -> (String)this.redisTemplate.execute(SCRIPT_LOCK, this.redisTemplate.getStringSerializer(), this.redisTemplate.getStringSerializer(), Collections.singletonList(lockKey), new Object[]{lockValue, String.valueOf(newExpire)})).thenApply(acquired -> {
            if (LOCK_SUCCESS.equals(acquired) && expire == -1L) {
                this.renewExpiration(newExpire, lockKey, lockValue);
            }
            return acquired;
        });
        try {
            lock = (String)((CompletableFuture)cf).get();
        }
        catch (Exception e) {
            log.error("lock error", (Throwable)e);
            throw new LockException();
        }
        boolean locked = LOCK_SUCCESS.equals(lock);
        return (String)this.obtainLockInstance(locked, lock);
    }

    public boolean releaseLock(String key, String value, String lockInstance) {
        String releaseResult = (String)this.redisTemplate.execute(SCRIPT_UNLOCK, this.redisTemplate.getStringSerializer(), this.redisTemplate.getStringSerializer(), Collections.singletonList(key), new Object[]{value});
        return Boolean.parseBoolean(releaseResult);
    }

    private void renewExpiration(final long expire, final String lockKey, final String lockValue) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (Boolean.TRUE.equals(RedisTemplateLockExecutor.this.redisTemplate.execute(SCRIPT_RENEWAL, Collections.singletonList(lockKey), new Object[]{lockValue, String.valueOf(expire)}))) {
                    RedisTemplateLockExecutor.this.renewExpiration(expire, lockKey, lockValue);
                }
            }
        }, expire / 3L);
    }

    public RedisTemplateLockExecutor(StringRedisTemplate redisTemplate, Lock4jProperties lock4jProperties) {
        this.redisTemplate = redisTemplate;
        this.lock4jProperties = lock4jProperties;
    }
}

