/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.signature;

import com.baomidou.kisso.common.encrypt.base64.Base64;
import com.baomidou.kisso.common.signature.ISign;
import com.baomidou.kisso.common.signature.ShaAlgorithm;
import com.baomidou.kisso.common.signature.SignAsymmetric;
import com.baomidou.kisso.common.signature.SignSymmetric;
import com.baomidou.kisso.common.signature.Signature;
import com.baomidou.kisso.exception.UnsupportedAlgorithmException;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;

public class Signer {
    private final ISign sign;
    private final Signature signature;
    private final ShaAlgorithm shaAlgorithm;
    private final Provider provider;

    public Signer(Key key, Signature signature) {
        this(key, signature, null);
    }

    public Signer(Key key, Signature signature, Provider provider) {
        Objects.requireNonNull(key, "Key cannot be null");
        this.signature = Objects.requireNonNull(signature, "Signature cannot be null");
        this.shaAlgorithm = signature.getShaAlgorithm();
        this.provider = provider;
        if (java.security.Signature.class.equals((Object)this.shaAlgorithm.getType())) {
            this.sign = new SignAsymmetric((PrivateKey)PrivateKey.class.cast(key));
        } else if (Mac.class.equals((Object)this.shaAlgorithm.getType())) {
            this.sign = new SignSymmetric(key);
        } else {
            throw new UnsupportedAlgorithmException(String.format("Unknown Algorithm type %s %s", this.shaAlgorithm.getPortableName(), this.shaAlgorithm.getType().getName()));
        }
        try {
            this.sign.sign(provider, this.shaAlgorithm, "validation".getBytes());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't initialise the Signer using the provided algorithm and key", e);
        }
    }

    public Signature sign(String method, String uri, Map<String, String> headers) throws IOException {
        String signingString = this.createSigningString(method, uri, headers);
        byte[] binarySignature = this.sign.sign(this.provider, this.shaAlgorithm, signingString.getBytes("UTF-8"));
        byte[] encoded = Base64.encode(binarySignature);
        String signedAndEncodedString = new String(encoded, "UTF-8");
        return new Signature(this.signature.getKeyId(), this.signature.getShaAlgorithm(), signedAndEncodedString, this.signature.getHeaders());
    }

    public String createSigningString(String method, String uri, Map<String, String> headers) throws IOException {
        return Signature.createSigningString(this.signature.getHeaders(), method, uri, headers);
    }
}

