/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.encrypt.Byte2Hex;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Salt {
    private static final Logger log = LoggerFactory.getLogger(MD5Salt.class);
    private String salt;
    private String algorithm;

    protected MD5Salt() {
    }

    public MD5Salt(String salt, String algorithm) {
        this.salt = salt;
        this.algorithm = algorithm;
    }

    public static String md5SaltEncode(String salt, String rawText) {
        return new MD5Salt(salt, "MD5").encode(rawText);
    }

    public static boolean md5SaltValid(String salt, String encodeText, String rawText) {
        return new MD5Salt(salt, "MD5").isValid(encodeText, rawText);
    }

    public String encode(String rawText) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.getAlgorithm());
            return Byte2Hex.byte2Hex(md.digest(this.mergeRawTextAndSalt(rawText).getBytes(SSOConfig.getSSOEncoding())));
        }
        catch (Exception e) {
            log.error(" MD5Salt encode exception.");
            e.printStackTrace();
            return null;
        }
    }

    public boolean isValid(String encodeText, String rawText) {
        return this.encode(rawText).equals(encodeText);
    }

    private String mergeRawTextAndSalt(String rawText) {
        if (rawText == null) {
            rawText = "";
        }
        if (this.getSalt() == null || "".equals(this.getSalt())) {
            return rawText;
        }
        StringBuffer mt = new StringBuffer();
        mt.append(rawText);
        mt.append("#");
        mt.append(this.getSalt());
        return mt.toString();
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

