/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.exception.AESException;
import com.baomidou.kisso.exception.KissoException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class Hash {
    public static String getSerialKey(String stringInput) {
        try {
            StringBuffer out = new StringBuffer();
            StringBuffer serialKey = new StringBuffer();
            serialKey.append(Hash.calculate(stringInput, "MD2"));
            serialKey.append(Hash.calculate(stringInput, "MD5"));
            serialKey.append(Hash.calculate(stringInput, "SHA1"));
            String serialNumberEncoded = serialKey.toString();
            out.append(serialNumberEncoded.charAt(32));
            out.append(serialNumberEncoded.charAt(76));
            out.append(serialNumberEncoded.charAt(100));
            out.append(serialNumberEncoded.charAt(50));
            out.append("-");
            out.append(serialNumberEncoded.charAt(2));
            out.append(serialNumberEncoded.charAt(91));
            out.append(serialNumberEncoded.charAt(73));
            out.append(serialNumberEncoded.charAt(72));
            out.append(serialNumberEncoded.charAt(98));
            out.append("-");
            out.append(serialNumberEncoded.charAt(47));
            out.append(serialNumberEncoded.charAt(65));
            out.append(serialNumberEncoded.charAt(18));
            out.append(serialNumberEncoded.charAt(85));
            out.append("-");
            out.append(serialNumberEncoded.charAt(27));
            out.append(serialNumberEncoded.charAt(53));
            out.append(serialNumberEncoded.charAt(102));
            out.append(serialNumberEncoded.charAt(15));
            out.append(serialNumberEncoded.charAt(99));
            return out.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new KissoException(e);
        }
    }

    public static String calculate(String stringInput, String algorithmName) throws NoSuchAlgorithmException {
        String hexMessageEncode = "";
        byte[] buffer = stringInput.getBytes();
        MessageDigest messageDigest = MessageDigest.getInstance(algorithmName);
        messageDigest.update(buffer);
        byte[] messageDigestBytes = messageDigest.digest();
        for (int index = 0; index < messageDigestBytes.length; ++index) {
            int countEncode = messageDigestBytes[index] & 0xFF;
            if (Integer.toHexString(countEncode).length() == 1) {
                hexMessageEncode = hexMessageEncode + "0";
            }
            hexMessageEncode = hexMessageEncode + Integer.toHexString(countEncode);
        }
        return hexMessageEncode;
    }

    public static String getSHA1(String token, String timestamp, String nonce, String encrypt) throws AESException {
        try {
            Object[] array = new String[]{token, timestamp, nonce, encrypt};
            StringBuffer sb = new StringBuffer();
            Arrays.sort(array);
            for (int i = 0; i < 4; ++i) {
                sb.append((String)array[i]);
            }
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(sb.toString().getBytes());
            byte[] digest = md.digest();
            StringBuffer hexstr = new StringBuffer();
            String shaHex = "";
            for (int i = 0; i < digest.length; ++i) {
                shaHex = Integer.toHexString(digest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexstr.append(0);
                }
                hexstr.append(shaHex);
            }
            return hexstr.toString();
        }
        catch (Exception e) {
            throw new AESException(-10004, (Throwable)e);
        }
    }
}

