/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso;

import com.baomidou.kisso.SSOAuthorization;
import com.baomidou.kisso.SSOCache;
import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.SSOPlugin;
import com.baomidou.kisso.exception.KissoException;
import com.baomidou.kisso.security.token.SSOToken;
import java.util.List;

public class SSOConfig {
    private String encoding = "UTF-8";
    private String signKey;
    private String signAlgorithm = "HS512";
    private String rsaJksStore = "key.jks";
    private String rsaCertStore = "public.cert";
    private String rsaAlias = "jwtkey";
    private String rsaKeypass = "llTs1p68K";
    private String rsaStorepass = "lLt66Y8L321";
    private String accessTokenName = "accessToken";
    private String cookieName = "uid";
    private String cookieDomain;
    private String cookiePath = "/";
    private boolean cookieSecure = false;
    private boolean cookieHttpOnly = true;
    private int cookieMaxAge = -1;
    private boolean cookieBrowser = false;
    private boolean cookieCheckIp = false;
    private String loginUrl = "";
    private String logoutUrl = "";
    private String paramReturnUrl = "ReturnURL";
    private int cacheExpires = -1;
    private SSOToken ssoToken;
    private boolean permissionUri = false;
    private List<SSOPlugin> pluginList;
    private SSOCache cache;
    private SSOAuthorization authorization;

    public static SSOConfig getInstance() {
        return SSOHelper.getSsoConfig();
    }

    public static String getSSOEncoding() {
        return SSOConfig.getInstance().getEncoding();
    }

    public String getRsaCertStore() {
        if (null == this.rsaCertStore) {
            throw new KissoException("public.cert not found");
        }
        return this.rsaCertStore;
    }

    public String getSignKey() {
        if (null == this.signKey) {
            return "Janfv5UgKhoDrH73EZT7m+81pgqLN3EjWKXZtqF9lQHH9WruxqX0+FkQys6XK0QXzSUckseOAZGeQyvfreA3tw==";
        }
        return this.signKey;
    }

    public String getRsaJksStore() {
        if (null == this.rsaJksStore) {
            throw new KissoException("jwt.jks not found");
        }
        return this.rsaJksStore;
    }

    public SSOAuthorization getAuthorization() {
        return this.authorization;
    }

    public SSOConfig setAuthorization(SSOAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    public static String toCacheKey(Object userId) {
        StringBuffer ck = new StringBuffer();
        ck.append("ssoTokenKey_");
        ck.append(userId);
        return ck.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public String getRsaAlias() {
        return this.rsaAlias;
    }

    public String getRsaKeypass() {
        return this.rsaKeypass;
    }

    public String getRsaStorepass() {
        return this.rsaStorepass;
    }

    public String getAccessTokenName() {
        return this.accessTokenName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public boolean isCookieBrowser() {
        return this.cookieBrowser;
    }

    public boolean isCookieCheckIp() {
        return this.cookieCheckIp;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getParamReturnUrl() {
        return this.paramReturnUrl;
    }

    public int getCacheExpires() {
        return this.cacheExpires;
    }

    public SSOToken getSsoToken() {
        return this.ssoToken;
    }

    public boolean isPermissionUri() {
        return this.permissionUri;
    }

    public List<SSOPlugin> getPluginList() {
        return this.pluginList;
    }

    public SSOCache getCache() {
        return this.cache;
    }

    public SSOConfig setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public SSOConfig setSignKey(String signKey) {
        this.signKey = signKey;
        return this;
    }

    public SSOConfig setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
        return this;
    }

    public SSOConfig setRsaJksStore(String rsaJksStore) {
        this.rsaJksStore = rsaJksStore;
        return this;
    }

    public SSOConfig setRsaCertStore(String rsaCertStore) {
        this.rsaCertStore = rsaCertStore;
        return this;
    }

    public SSOConfig setRsaAlias(String rsaAlias) {
        this.rsaAlias = rsaAlias;
        return this;
    }

    public SSOConfig setRsaKeypass(String rsaKeypass) {
        this.rsaKeypass = rsaKeypass;
        return this;
    }

    public SSOConfig setRsaStorepass(String rsaStorepass) {
        this.rsaStorepass = rsaStorepass;
        return this;
    }

    public SSOConfig setAccessTokenName(String accessTokenName) {
        this.accessTokenName = accessTokenName;
        return this;
    }

    public SSOConfig setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public SSOConfig setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
        return this;
    }

    public SSOConfig setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    public SSOConfig setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
        return this;
    }

    public SSOConfig setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
        return this;
    }

    public SSOConfig setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
        return this;
    }

    public SSOConfig setCookieBrowser(boolean cookieBrowser) {
        this.cookieBrowser = cookieBrowser;
        return this;
    }

    public SSOConfig setCookieCheckIp(boolean cookieCheckIp) {
        this.cookieCheckIp = cookieCheckIp;
        return this;
    }

    public SSOConfig setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
        return this;
    }

    public SSOConfig setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    public SSOConfig setParamReturnUrl(String paramReturnUrl) {
        this.paramReturnUrl = paramReturnUrl;
        return this;
    }

    public SSOConfig setCacheExpires(int cacheExpires) {
        this.cacheExpires = cacheExpires;
        return this;
    }

    public SSOConfig setSsoToken(SSOToken ssoToken) {
        this.ssoToken = ssoToken;
        return this;
    }

    public SSOConfig setPermissionUri(boolean permissionUri) {
        this.permissionUri = permissionUri;
        return this;
    }

    public SSOConfig setPluginList(List<SSOPlugin> pluginList) {
        this.pluginList = pluginList;
        return this;
    }

    public SSOConfig setCache(SSOCache cache) {
        this.cache = cache;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSOConfig)) {
            return false;
        }
        SSOConfig other = (SSOConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        String this$signKey = this.getSignKey();
        String other$signKey = other.getSignKey();
        if (this$signKey == null ? other$signKey != null : !this$signKey.equals(other$signKey)) {
            return false;
        }
        String this$signAlgorithm = this.getSignAlgorithm();
        String other$signAlgorithm = other.getSignAlgorithm();
        if (this$signAlgorithm == null ? other$signAlgorithm != null : !this$signAlgorithm.equals(other$signAlgorithm)) {
            return false;
        }
        String this$rsaJksStore = this.getRsaJksStore();
        String other$rsaJksStore = other.getRsaJksStore();
        if (this$rsaJksStore == null ? other$rsaJksStore != null : !this$rsaJksStore.equals(other$rsaJksStore)) {
            return false;
        }
        String this$rsaCertStore = this.getRsaCertStore();
        String other$rsaCertStore = other.getRsaCertStore();
        if (this$rsaCertStore == null ? other$rsaCertStore != null : !this$rsaCertStore.equals(other$rsaCertStore)) {
            return false;
        }
        String this$rsaAlias = this.getRsaAlias();
        String other$rsaAlias = other.getRsaAlias();
        if (this$rsaAlias == null ? other$rsaAlias != null : !this$rsaAlias.equals(other$rsaAlias)) {
            return false;
        }
        String this$rsaKeypass = this.getRsaKeypass();
        String other$rsaKeypass = other.getRsaKeypass();
        if (this$rsaKeypass == null ? other$rsaKeypass != null : !this$rsaKeypass.equals(other$rsaKeypass)) {
            return false;
        }
        String this$rsaStorepass = this.getRsaStorepass();
        String other$rsaStorepass = other.getRsaStorepass();
        if (this$rsaStorepass == null ? other$rsaStorepass != null : !this$rsaStorepass.equals(other$rsaStorepass)) {
            return false;
        }
        String this$accessTokenName = this.getAccessTokenName();
        String other$accessTokenName = other.getAccessTokenName();
        if (this$accessTokenName == null ? other$accessTokenName != null : !this$accessTokenName.equals(other$accessTokenName)) {
            return false;
        }
        String this$cookieName = this.getCookieName();
        String other$cookieName = other.getCookieName();
        if (this$cookieName == null ? other$cookieName != null : !this$cookieName.equals(other$cookieName)) {
            return false;
        }
        String this$cookieDomain = this.getCookieDomain();
        String other$cookieDomain = other.getCookieDomain();
        if (this$cookieDomain == null ? other$cookieDomain != null : !this$cookieDomain.equals(other$cookieDomain)) {
            return false;
        }
        String this$cookiePath = this.getCookiePath();
        String other$cookiePath = other.getCookiePath();
        if (this$cookiePath == null ? other$cookiePath != null : !this$cookiePath.equals(other$cookiePath)) {
            return false;
        }
        if (this.isCookieSecure() != other.isCookieSecure()) {
            return false;
        }
        if (this.isCookieHttpOnly() != other.isCookieHttpOnly()) {
            return false;
        }
        if (this.getCookieMaxAge() != other.getCookieMaxAge()) {
            return false;
        }
        if (this.isCookieBrowser() != other.isCookieBrowser()) {
            return false;
        }
        if (this.isCookieCheckIp() != other.isCookieCheckIp()) {
            return false;
        }
        String this$loginUrl = this.getLoginUrl();
        String other$loginUrl = other.getLoginUrl();
        if (this$loginUrl == null ? other$loginUrl != null : !this$loginUrl.equals(other$loginUrl)) {
            return false;
        }
        String this$logoutUrl = this.getLogoutUrl();
        String other$logoutUrl = other.getLogoutUrl();
        if (this$logoutUrl == null ? other$logoutUrl != null : !this$logoutUrl.equals(other$logoutUrl)) {
            return false;
        }
        String this$paramReturnUrl = this.getParamReturnUrl();
        String other$paramReturnUrl = other.getParamReturnUrl();
        if (this$paramReturnUrl == null ? other$paramReturnUrl != null : !this$paramReturnUrl.equals(other$paramReturnUrl)) {
            return false;
        }
        if (this.getCacheExpires() != other.getCacheExpires()) {
            return false;
        }
        SSOToken this$ssoToken = this.getSsoToken();
        SSOToken other$ssoToken = other.getSsoToken();
        if (this$ssoToken == null ? other$ssoToken != null : !this$ssoToken.equals(other$ssoToken)) {
            return false;
        }
        if (this.isPermissionUri() != other.isPermissionUri()) {
            return false;
        }
        List<SSOPlugin> this$pluginList = this.getPluginList();
        List<SSOPlugin> other$pluginList = other.getPluginList();
        if (this$pluginList == null ? other$pluginList != null : !((Object)this$pluginList).equals(other$pluginList)) {
            return false;
        }
        SSOCache this$cache = this.getCache();
        SSOCache other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
            return false;
        }
        SSOAuthorization this$authorization = this.getAuthorization();
        SSOAuthorization other$authorization = other.getAuthorization();
        return !(this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SSOConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        String $signKey = this.getSignKey();
        result = result * 59 + ($signKey == null ? 43 : $signKey.hashCode());
        String $signAlgorithm = this.getSignAlgorithm();
        result = result * 59 + ($signAlgorithm == null ? 43 : $signAlgorithm.hashCode());
        String $rsaJksStore = this.getRsaJksStore();
        result = result * 59 + ($rsaJksStore == null ? 43 : $rsaJksStore.hashCode());
        String $rsaCertStore = this.getRsaCertStore();
        result = result * 59 + ($rsaCertStore == null ? 43 : $rsaCertStore.hashCode());
        String $rsaAlias = this.getRsaAlias();
        result = result * 59 + ($rsaAlias == null ? 43 : $rsaAlias.hashCode());
        String $rsaKeypass = this.getRsaKeypass();
        result = result * 59 + ($rsaKeypass == null ? 43 : $rsaKeypass.hashCode());
        String $rsaStorepass = this.getRsaStorepass();
        result = result * 59 + ($rsaStorepass == null ? 43 : $rsaStorepass.hashCode());
        String $accessTokenName = this.getAccessTokenName();
        result = result * 59 + ($accessTokenName == null ? 43 : $accessTokenName.hashCode());
        String $cookieName = this.getCookieName();
        result = result * 59 + ($cookieName == null ? 43 : $cookieName.hashCode());
        String $cookieDomain = this.getCookieDomain();
        result = result * 59 + ($cookieDomain == null ? 43 : $cookieDomain.hashCode());
        String $cookiePath = this.getCookiePath();
        result = result * 59 + ($cookiePath == null ? 43 : $cookiePath.hashCode());
        result = result * 59 + (this.isCookieSecure() ? 79 : 97);
        result = result * 59 + (this.isCookieHttpOnly() ? 79 : 97);
        result = result * 59 + this.getCookieMaxAge();
        result = result * 59 + (this.isCookieBrowser() ? 79 : 97);
        result = result * 59 + (this.isCookieCheckIp() ? 79 : 97);
        String $loginUrl = this.getLoginUrl();
        result = result * 59 + ($loginUrl == null ? 43 : $loginUrl.hashCode());
        String $logoutUrl = this.getLogoutUrl();
        result = result * 59 + ($logoutUrl == null ? 43 : $logoutUrl.hashCode());
        String $paramReturnUrl = this.getParamReturnUrl();
        result = result * 59 + ($paramReturnUrl == null ? 43 : $paramReturnUrl.hashCode());
        result = result * 59 + this.getCacheExpires();
        SSOToken $ssoToken = this.getSsoToken();
        result = result * 59 + ($ssoToken == null ? 43 : $ssoToken.hashCode());
        result = result * 59 + (this.isPermissionUri() ? 79 : 97);
        List<SSOPlugin> $pluginList = this.getPluginList();
        result = result * 59 + ($pluginList == null ? 43 : ((Object)$pluginList).hashCode());
        SSOCache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        SSOAuthorization $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        return result;
    }

    public String toString() {
        return "SSOConfig(encoding=" + this.getEncoding() + ", signKey=" + this.getSignKey() + ", signAlgorithm=" + this.getSignAlgorithm() + ", rsaJksStore=" + this.getRsaJksStore() + ", rsaCertStore=" + this.getRsaCertStore() + ", rsaAlias=" + this.getRsaAlias() + ", rsaKeypass=" + this.getRsaKeypass() + ", rsaStorepass=" + this.getRsaStorepass() + ", accessTokenName=" + this.getAccessTokenName() + ", cookieName=" + this.getCookieName() + ", cookieDomain=" + this.getCookieDomain() + ", cookiePath=" + this.getCookiePath() + ", cookieSecure=" + this.isCookieSecure() + ", cookieHttpOnly=" + this.isCookieHttpOnly() + ", cookieMaxAge=" + this.getCookieMaxAge() + ", cookieBrowser=" + this.isCookieBrowser() + ", cookieCheckIp=" + this.isCookieCheckIp() + ", loginUrl=" + this.getLoginUrl() + ", logoutUrl=" + this.getLogoutUrl() + ", paramReturnUrl=" + this.getParamReturnUrl() + ", cacheExpires=" + this.getCacheExpires() + ", ssoToken=" + this.getSsoToken() + ", permissionUri=" + this.isPermissionUri() + ", pluginList=" + this.getPluginList() + ", cache=" + this.getCache() + ", authorization=" + this.getAuthorization() + ")";
    }
}

