/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.ds;

import com.baomidou.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class GroupDataSource {
    private String groupName;
    private DynamicDataSourceStrategy dynamicDataSourceStrategy;
    private Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();

    public GroupDataSource(String groupName, DynamicDataSourceStrategy dynamicDataSourceStrategy) {
        this.groupName = groupName;
        this.dynamicDataSourceStrategy = dynamicDataSourceStrategy;
    }

    public DataSource addDatasource(String ds, DataSource dataSource) {
        return this.dataSourceMap.put(ds, dataSource);
    }

    public DataSource removeDatasource(String ds) {
        return this.dataSourceMap.remove(ds);
    }

    public String determineDsKey() {
        return this.dynamicDataSourceStrategy.determineDSKey(new ArrayList<String>(this.dataSourceMap.keySet()));
    }

    public DataSource determineDataSource() {
        return this.dataSourceMap.get(this.determineDsKey());
    }

    public int size() {
        return this.dataSourceMap.size();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public DynamicDataSourceStrategy getDynamicDataSourceStrategy() {
        return this.dynamicDataSourceStrategy;
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setDynamicDataSourceStrategy(DynamicDataSourceStrategy dynamicDataSourceStrategy) {
        this.dynamicDataSourceStrategy = dynamicDataSourceStrategy;
    }

    public void setDataSourceMap(Map<String, DataSource> dataSourceMap) {
        this.dataSourceMap = dataSourceMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupDataSource)) {
            return false;
        }
        GroupDataSource other = (GroupDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        DynamicDataSourceStrategy this$dynamicDataSourceStrategy = this.getDynamicDataSourceStrategy();
        DynamicDataSourceStrategy other$dynamicDataSourceStrategy = other.getDynamicDataSourceStrategy();
        if (this$dynamicDataSourceStrategy == null ? other$dynamicDataSourceStrategy != null : !this$dynamicDataSourceStrategy.equals(other$dynamicDataSourceStrategy)) {
            return false;
        }
        Map<String, DataSource> this$dataSourceMap = this.getDataSourceMap();
        Map<String, DataSource> other$dataSourceMap = other.getDataSourceMap();
        return !(this$dataSourceMap == null ? other$dataSourceMap != null : !((Object)this$dataSourceMap).equals(other$dataSourceMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupDataSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        DynamicDataSourceStrategy $dynamicDataSourceStrategy = this.getDynamicDataSourceStrategy();
        result = result * 59 + ($dynamicDataSourceStrategy == null ? 43 : $dynamicDataSourceStrategy.hashCode());
        Map<String, DataSource> $dataSourceMap = this.getDataSourceMap();
        result = result * 59 + ($dataSourceMap == null ? 43 : ((Object)$dataSourceMap).hashCode());
        return result;
    }

    public String toString() {
        return "GroupDataSource(groupName=" + this.getGroupName() + ", dynamicDataSourceStrategy=" + this.getDynamicDataSourceStrategy() + ", dataSourceMap=" + this.getDataSourceMap() + ")";
    }
}

