/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.exception.ErrorCreateDataSourceException;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidSlf4jConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidWallConfigUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class DruidDataSourceCreator
implements DataSourceCreator {
    private static Boolean druidExists = false;
    private DruidConfig gConfig;
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    public DruidDataSourceCreator(DruidConfig gConfig) {
        this.gConfig = gConfig;
    }

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUsername(dataSourceProperty.getUsername());
        dataSource.setPassword(dataSourceProperty.getPassword());
        dataSource.setUrl(dataSourceProperty.getUrl());
        dataSource.setName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            dataSource.setDriverClassName(driverClassName);
        }
        DruidConfig config = dataSourceProperty.getDruid();
        Properties properties = config.toProperties(this.gConfig);
        List<Filter> proxyFilters = this.initFilters(dataSourceProperty, properties);
        dataSource.setProxyFilters(proxyFilters);
        dataSource.configFromPropety(properties);
        dataSource.setConnectProperties(config.getConnectionProperties());
        this.setParam(dataSource, config);
        if (Boolean.FALSE.equals(dataSourceProperty.getLazy())) {
            try {
                dataSource.init();
            }
            catch (SQLException e) {
                throw new ErrorCreateDataSourceException("druid create error", e);
            }
        }
        return dataSource;
    }

    private List<Filter> initFilters(DataSourceProperty dataSourceProperty, Properties properties) {
        ArrayList<Filter> proxyFilters = new ArrayList<Filter>(2);
        String filters = properties.getProperty("druid.filters");
        if (!StringUtils.isEmpty((Object)filters)) {
            if (filters.contains("stat")) {
                StatFilter statFilter = new StatFilter();
                statFilter.configFromProperties(properties);
                proxyFilters.add((Filter)statFilter);
            }
            if (filters.contains("wall")) {
                WallConfig wallConfig = DruidWallConfigUtil.toWallConfig(dataSourceProperty.getDruid().getWall(), this.gConfig.getWall());
                WallFilter wallFilter = new WallFilter();
                wallFilter.setConfig(wallConfig);
                proxyFilters.add((Filter)wallFilter);
            }
            if (filters.contains("slf4j")) {
                Slf4jLogFilter slf4jLogFilter = new Slf4jLogFilter();
                DruidSlf4jConfig slf4jConfig = this.gConfig.getSlf4j();
                slf4jLogFilter.setStatementLogEnabled(slf4jConfig.getEnable().booleanValue());
                slf4jLogFilter.setStatementExecutableSqlLogEnable(slf4jConfig.getStatementExecutableSqlLogEnable().booleanValue());
                proxyFilters.add((Filter)slf4jLogFilter);
            }
        }
        if (this.applicationContext != null) {
            for (String filterId : this.gConfig.getProxyFilters()) {
                proxyFilters.add((Filter)this.applicationContext.getBean(filterId, Filter.class));
            }
        }
        return proxyFilters;
    }

    private void setParam(DruidDataSource dataSource, DruidConfig config) {
        Integer transactionQueryTimeout;
        Integer queryTimeOut;
        Boolean logAbandoned;
        Boolean abandoned;
        Integer timeout;
        Boolean breakAfterAcquireFailure;
        Integer connectionErrorRetryAttempts;
        Boolean sharePreparedStatements;
        Integer validationQueryTimeout;
        Boolean testOnReturn;
        Integer defaultTransactionIsolation;
        Boolean defaultReadOnly;
        Boolean defaultAutoCommit;
        String defaultCatalog;
        String string = defaultCatalog = config.getDefaultCatalog() == null ? this.gConfig.getDefaultCatalog() : config.getDefaultCatalog();
        if (defaultCatalog != null) {
            dataSource.setDefaultCatalog(defaultCatalog);
        }
        Boolean bl = defaultAutoCommit = config.getDefaultAutoCommit() == null ? this.gConfig.getDefaultAutoCommit() : config.getDefaultAutoCommit();
        if (defaultAutoCommit != null && !defaultAutoCommit.booleanValue()) {
            dataSource.setDefaultAutoCommit(false);
        }
        Boolean bl2 = defaultReadOnly = config.getDefaultReadOnly() == null ? this.gConfig.getDefaultReadOnly() : config.getDefaultReadOnly();
        if (defaultReadOnly != null) {
            dataSource.setDefaultReadOnly(defaultReadOnly);
        }
        Integer n = defaultTransactionIsolation = config.getDefaultTransactionIsolation() == null ? this.gConfig.getDefaultTransactionIsolation() : config.getDefaultTransactionIsolation();
        if (defaultTransactionIsolation != null) {
            dataSource.setDefaultTransactionIsolation(defaultTransactionIsolation);
        }
        Boolean bl3 = testOnReturn = config.getTestOnReturn() == null ? this.gConfig.getTestOnReturn() : config.getTestOnReturn();
        if (testOnReturn != null && testOnReturn.booleanValue()) {
            dataSource.setTestOnReturn(true);
        }
        Integer n2 = validationQueryTimeout = config.getValidationQueryTimeout() == null ? this.gConfig.getValidationQueryTimeout() : config.getValidationQueryTimeout();
        if (validationQueryTimeout != null && !validationQueryTimeout.equals(-1)) {
            dataSource.setValidationQueryTimeout(validationQueryTimeout.intValue());
        }
        Boolean bl4 = sharePreparedStatements = config.getSharePreparedStatements() == null ? this.gConfig.getSharePreparedStatements() : config.getSharePreparedStatements();
        if (sharePreparedStatements != null && sharePreparedStatements.booleanValue()) {
            dataSource.setSharePreparedStatements(true);
        }
        Integer n3 = connectionErrorRetryAttempts = config.getConnectionErrorRetryAttempts() == null ? this.gConfig.getConnectionErrorRetryAttempts() : config.getConnectionErrorRetryAttempts();
        if (connectionErrorRetryAttempts != null && !connectionErrorRetryAttempts.equals(1)) {
            dataSource.setConnectionErrorRetryAttempts(connectionErrorRetryAttempts.intValue());
        }
        Boolean bl5 = breakAfterAcquireFailure = config.getBreakAfterAcquireFailure() == null ? this.gConfig.getBreakAfterAcquireFailure() : config.getBreakAfterAcquireFailure();
        if (breakAfterAcquireFailure != null && breakAfterAcquireFailure.booleanValue()) {
            dataSource.setBreakAfterAcquireFailure(true);
        }
        Integer n4 = timeout = config.getRemoveAbandonedTimeoutMillis() == null ? this.gConfig.getRemoveAbandonedTimeoutMillis() : config.getRemoveAbandonedTimeoutMillis();
        if (timeout != null) {
            dataSource.setRemoveAbandonedTimeoutMillis((long)timeout.intValue());
        }
        Boolean bl6 = abandoned = config.getRemoveAbandoned() == null ? this.gConfig.getRemoveAbandoned() : config.getRemoveAbandoned();
        if (abandoned != null) {
            dataSource.setRemoveAbandoned(abandoned.booleanValue());
        }
        Boolean bl7 = logAbandoned = config.getLogAbandoned() == null ? this.gConfig.getLogAbandoned() : config.getLogAbandoned();
        if (logAbandoned != null) {
            dataSource.setLogAbandoned(logAbandoned.booleanValue());
        }
        Integer n5 = queryTimeOut = config.getQueryTimeout() == null ? this.gConfig.getQueryTimeout() : config.getQueryTimeout();
        if (queryTimeOut != null) {
            dataSource.setQueryTimeout(queryTimeOut.intValue());
        }
        Integer n6 = transactionQueryTimeout = config.getTransactionQueryTimeout() == null ? this.gConfig.getTransactionQueryTimeout() : config.getTransactionQueryTimeout();
        if (transactionQueryTimeout != null) {
            dataSource.setTransactionQueryTimeout(transactionQueryTimeout.intValue());
        }
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null && druidExists != false || type != null && "com.alibaba.druid.pool.DruidDataSource".equals(type.getName());
    }

    public DruidConfig getGConfig() {
        return this.gConfig;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setGConfig(DruidConfig gConfig) {
        this.gConfig = gConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidDataSourceCreator)) {
            return false;
        }
        DruidDataSourceCreator other = (DruidDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DruidConfig this$gConfig = this.getGConfig();
        DruidConfig other$gConfig = other.getGConfig();
        if (this$gConfig == null ? other$gConfig != null : !((Object)this$gConfig).equals(other$gConfig)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        return !(this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DruidDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DruidConfig $gConfig = this.getGConfig();
        result = result * 59 + ($gConfig == null ? 43 : ((Object)$gConfig).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        return result;
    }

    public String toString() {
        return "DruidDataSourceCreator(gConfig=" + this.getGConfig() + ", applicationContext=" + this.getApplicationContext() + ")";
    }

    static {
        try {
            Class.forName("com.alibaba.druid.pool.DruidDataSource");
            druidExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

