/*
 * Decompiled with CFR 0.152.
 */
package com.banzhi.emptylibrary;

import android.app.Activity;
import android.content.Context;
import android.support.constraint.ConstraintLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.banzhi.emptylibrary.annotation.ViewClick;
import com.banzhi.emptylibrary.enums.LoadType;
import com.banzhi.emptylibrary.interfaces.OnLayoutClickListener;
import com.banzhi.emptylibrary.interfaces.ViewLoader;
import com.banzhi.emptylibrary.utils.ViewUtils;
import com.banzhi.emptylibrary.view.SimpleEmptyView;
import com.banzhi.emptylibrary.view.SimpleErrorView;
import com.banzhi.emptylibrary.view.SimpleLoadingView;
import java.lang.reflect.Method;

public class ELoad
implements View.OnClickListener {
    public static final String TAG_EMPTY = "empty";
    public static final String TAG_ERROR = "error";
    Context mContext;
    View targetView;
    View mEmptyView;
    View mErrorView;
    View mLoadView;
    boolean isFillWindow;
    OnLayoutClickListener mListener;
    Object object;

    private ELoad(Builder builder) {
        this.mContext = builder.context;
        this.targetView = builder.contentView;
        this.mEmptyView = builder.emptyView;
        this.mErrorView = builder.errorView;
        this.mLoadView = builder.loadingView;
        this.isFillWindow = builder.isFillWindow;
        this.object = builder.object;
        this.mListener = builder.listener;
        this.init();
        this.initListener();
    }

    private void initListener() {
        this.mEmptyView.setTag((Object)LoadType.EMPTY);
        this.mErrorView.setTag((Object)LoadType.ERROR);
        this.mEmptyView.setOnClickListener((View.OnClickListener)this);
        this.mErrorView.setOnClickListener((View.OnClickListener)this);
    }

    public ELoad(Context context) {
        this.mContext = context;
    }

    private void init() {
        if (this.isFillWindow) {
            this.whole();
        } else {
            this.partial();
        }
    }

    public void whole() {
        if (this.mContext instanceof Activity) {
            Activity activity = (Activity)this.mContext;
            ViewGroup parentView = (ViewGroup)activity.findViewById(0x1020002);
            this.targetView = parentView.getChildAt(0);
            parentView.addView(this.mEmptyView, this.targetView.getLayoutParams());
            parentView.addView(this.mErrorView, this.targetView.getLayoutParams());
            parentView.addView(this.mLoadView, this.targetView.getLayoutParams());
            this.showContent();
        } else {
            this.partial();
        }
    }

    public void partial() {
        ConstraintLayout emptyContainer;
        if (this.targetView == null) {
            return;
        }
        ViewGroup parent = (ViewGroup)this.targetView.getParent();
        int index = parent.indexOfChild(this.targetView);
        ViewGroup.LayoutParams targetParams = this.targetView.getLayoutParams();
        parent.removeView(this.targetView);
        if (targetParams instanceof ViewGroup.MarginLayoutParams) {
            emptyContainer = new ConstraintLayout(this.mContext);
            emptyContainer.setId(this.targetView.getId());
            this.targetView.setId(-1);
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)targetParams;
            emptyContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            parent.addView((View)emptyContainer, index, (ViewGroup.LayoutParams)layoutParams);
        } else {
            emptyContainer = new FrameLayout(this.mContext);
            emptyContainer.setLayoutParams(targetParams);
            parent.addView((View)emptyContainer, index, targetParams);
        }
        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(-1, -1);
        emptyContainer.addView(this.targetView, (ViewGroup.LayoutParams)params);
        emptyContainer.addView(this.mEmptyView, (ViewGroup.LayoutParams)params);
        emptyContainer.addView(this.mErrorView, (ViewGroup.LayoutParams)params);
        emptyContainer.addView(this.mLoadView, (ViewGroup.LayoutParams)params);
        this.showContent();
    }

    public void showContent() {
        this.targetView.setVisibility(0);
        this.mEmptyView.setVisibility(8);
        this.mErrorView.setVisibility(8);
        this.mLoadView.setVisibility(8);
    }

    public void showError() {
        this.targetView.setVisibility(8);
        this.mEmptyView.setVisibility(8);
        this.mErrorView.setVisibility(0);
        this.mLoadView.setVisibility(8);
    }

    public void showEmpty() {
        this.targetView.setVisibility(8);
        this.mEmptyView.setVisibility(0);
        this.mErrorView.setVisibility(8);
        this.mLoadView.setVisibility(8);
    }

    public void showLoading() {
        this.targetView.setVisibility(8);
        this.mEmptyView.setVisibility(8);
        this.mErrorView.setVisibility(8);
        this.mLoadView.setVisibility(0);
    }

    public void onClick(View v) {
        ViewUtils.setDelayedClickable(v, 500);
        Object object = v.getTag();
        if (null != object) {
            LoadType tag = (LoadType)((Object)v.getTag());
            if (this.mListener != null) {
                if (LoadType.EMPTY == tag) {
                    this.mListener.onEmptyViewClick();
                }
                if (LoadType.ERROR == tag) {
                    this.mListener.onErrorViewClick();
                }
            } else {
                this.clickLayout(tag);
            }
        }
    }

    private void clickLayout(LoadType type) {
        if (this.object == null) {
            return;
        }
        Class<?> clazz = this.object.getClass();
        try {
            Method[] methods;
            for (Method m : methods = clazz.getDeclaredMethods()) {
                if (m.getAnnotation(ViewClick.class) == null) continue;
                ViewClick annotation = m.getAnnotation(ViewClick.class);
                LoadType values = annotation.value();
                if (values == LoadType.BOTH || values == type) {
                    m.setAccessible(true);
                    m.invoke(this.object, new Object[0]);
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        Context context;
        View contentView;
        View emptyView;
        View errorView;
        View loadingView;
        LayoutInflater inflater;
        boolean isFillWindow;
        Object object;
        OnLayoutClickListener listener;

        public Builder(Context context, View contentView) {
            this.context = context;
            this.contentView = contentView;
            this.inflater = LayoutInflater.from((Context)context);
        }

        public Builder(Context context) {
            this(context, null);
            this.isFillWindow = true;
        }

        public Builder isFillWindow() {
            this.isFillWindow = true;
            return this;
        }

        public Builder isFillWindow(boolean isFill) {
            this.isFillWindow = isFill;
            if (!this.isFillWindow) {
                throw new NullPointerException("\u5982\u679cisFillWindow=false,\u5fc5\u987b\u8bbe\u7f6etargetview!");
            }
            return this;
        }

        public Builder setEmptyView(View emptyView) {
            this.emptyView = emptyView;
            return this;
        }

        public Builder setErrorView(View errorView) {
            this.errorView = errorView;
            return this;
        }

        public Builder setLoadingView(View loadingView) {
            this.loadingView = loadingView;
            return this;
        }

        public Builder setEmptyView(ViewLoader loader) {
            this.emptyView = loader.getView();
            return this;
        }

        public Builder setErrorView(ViewLoader loader) {
            this.errorView = loader.getView();
            return this;
        }

        public Builder setLoadingView(ViewLoader loader) {
            this.loadingView = loader.getView();
            return this;
        }

        public ELoad build() {
            if (this.emptyView == null) {
                this.emptyView = new SimpleEmptyView(this.context).getView();
            }
            if (this.errorView == null) {
                this.errorView = new SimpleErrorView(this.context).getView();
            }
            if (this.loadingView == null) {
                this.loadingView = new SimpleLoadingView(this.context).getView();
            }
            return new ELoad(this);
        }

        public ELoad build(OnLayoutClickListener listener) {
            this.listener = listener;
            return this.build();
        }

        public ELoad build(Object o) {
            this.object = o;
            return this.build();
        }
    }
}

