/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.core_av.usb_camera.internal;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 H2\u00020\u0001:\u0001HB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bBG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fB9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0012\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010@\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000J\b\u0010B\u001a\u00020+H\u0016J\u0006\u0010C\u001a\u00020DJ\u0018\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020\u00132\u0006\u0010G\u001a\u00020\u0003H\u0016R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010$\"\u0004\b.\u0010&R\u001a\u0010/\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010$\"\u0004\b1\u0010&R\u001a\u00102\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010$\"\u0004\b4\u0010&R\u001c\u00105\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010$\"\u0004\b<\u0010&R\u001a\u0010=\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010$\"\u0004\b?\u0010&\u00a8\u0006I"}, d2={"Lcom/bandyer/core_av/usb_camera/internal/Size;", "Landroid/os/Parcelable;", "_type", "", "_frame_type", "_index", "_width", "_height", "(IIIII)V", "_min_intervals", "_max_intervals", "_step", "(IIIIIIII)V", "_intervals", "", "(IIIII[I)V", "other", "(Lcom/bandyer/core_av/usb_camera/internal/Size;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "frameRate", "", "currentFrameRate", "getCurrentFrameRate", "()F", "setCurrentFrameRate", "(F)V", "fps", "", "getFps", "()[F", "setFps", "([F)V", "frameIntervalIndex", "getFrameIntervalIndex", "()I", "setFrameIntervalIndex", "(I)V", "frameIntervalType", "getFrameIntervalType", "setFrameIntervalType", "frameRates", "", "frame_type", "getFrame_type", "setFrame_type", "height", "getHeight", "setHeight", "index", "getIndex", "setIndex", "intervals", "getIntervals", "()[I", "setIntervals", "([I)V", "type", "getType", "setType", "width", "getWidth", "setWidth", "describeContents", "set", "toString", "updateFrameRate", "", "writeToParcel", "dest", "flags", "Companion", "extension_usb_camera_release"})
public final class Size
implements Parcelable {
    private int type;
    private int frame_type;
    private int index;
    private int width;
    private int height;
    private int frameIntervalType;
    private int frameIntervalIndex;
    @Nullable
    private int[] intervals;
    @Nullable
    private float[] fps;
    private String frameRates;
    @NotNull
    private static final Parcelable.Creator<Size> CREATOR;
    public static final Companion Companion;

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final int getFrame_type() {
        return this.frame_type;
    }

    public final void setFrame_type(int n) {
        this.frame_type = n;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final int getFrameIntervalType() {
        return this.frameIntervalType;
    }

    public final void setFrameIntervalType(int n) {
        this.frameIntervalType = n;
    }

    public final int getFrameIntervalIndex() {
        return this.frameIntervalIndex;
    }

    public final void setFrameIntervalIndex(int n) {
        this.frameIntervalIndex = n;
    }

    @Nullable
    public final int[] getIntervals() {
        return this.intervals;
    }

    public final void setIntervals(@Nullable int[] nArray) {
        this.intervals = nArray;
    }

    @Nullable
    public final float[] getFps() {
        return this.fps;
    }

    public final void setFps(@Nullable float[] fArray) {
        this.fps = fArray;
    }

    @NotNull
    public final Size set(@Nullable Size other) {
        if (other != null) {
            int n;
            int n2;
            this.type = other.type;
            this.frame_type = other.frame_type;
            this.index = other.index;
            this.width = other.width;
            this.height = other.height;
            this.frameIntervalType = other.frameIntervalType;
            this.frameIntervalIndex = other.frameIntervalIndex;
            if (other.intervals != null) {
                Intrinsics.checkNotNull((Object)other.intervals);
                n2 = other.intervals.length;
            } else {
                n2 = n = -1;
            }
            if (n > 0) {
                this.intervals = new int[n];
                Intrinsics.checkNotNull((Object)other.intervals);
                System.arraycopy(other.intervals, 0, this.intervals, 0, n);
            } else {
                this.intervals = null;
            }
            this.updateFrameRate();
        }
        return this;
    }

    public final float getCurrentFrameRate() throws IllegalStateException {
        int n;
        int n2;
        if (this.fps != null) {
            Intrinsics.checkNotNull((Object)this.fps);
            n2 = this.fps.length;
        } else {
            n2 = n = 0;
        }
        if (this.frameIntervalIndex >= 0 && this.frameIntervalIndex < n) {
            Intrinsics.checkNotNull((Object)this.fps);
            return this.fps[this.frameIntervalIndex];
        }
        throw (Throwable)new IllegalStateException("unknown frame rate or not ready");
    }

    /*
     * WARNING - void declaration
     */
    public final void setCurrentFrameRate(float frameRate) {
        int n;
        int index = -1;
        if (this.fps != null) {
            Intrinsics.checkNotNull((Object)this.fps);
            n = this.fps.length;
        } else {
            n = 0;
        }
        int n2 = n;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            void i;
            Intrinsics.checkNotNull((Object)this.fps);
            if (this.fps[i] <= frameRate) {
                index = i;
                break;
            }
            ++i;
        }
        this.frameIntervalIndex = index;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeInt(this.type);
        dest.writeInt(this.frame_type);
        dest.writeInt(this.index);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.frameIntervalType);
        dest.writeInt(this.frameIntervalIndex);
        if (this.intervals != null) {
            dest.writeIntArray(this.intervals);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateFrameRate() {
        int n;
        int n2 = this.frameIntervalType;
        if (n2 > 0) {
            this.fps = new float[n2];
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                void i;
                Intrinsics.checkNotNull((Object)this.fps);
                Intrinsics.checkNotNull((Object)this.intervals);
                this.fps[i] = 1.0E7f / (float)this.intervals[i];
                Intrinsics.checkNotNull((Object)this.fps);
                float f = this.fps[i];
                ++i;
            }
        } else if (n2 == 0) {
            try {
                int n5;
                float fps;
                int n6;
                Intrinsics.checkNotNull((Object)this.intervals);
                int n7 = this.intervals[0];
                Intrinsics.checkNotNull((Object)this.intervals);
                int min = Math.min(n7, this.intervals[1]);
                Intrinsics.checkNotNull((Object)this.intervals);
                int n8 = this.intervals[0];
                Intrinsics.checkNotNull((Object)this.intervals);
                int max = Math.max(n8, this.intervals[1]);
                Intrinsics.checkNotNull((Object)this.intervals);
                int step = this.intervals[2];
                if (step > 0) {
                    int m = 0;
                    Size size = this;
                    int n9 = 0;
                    n6 = 0;
                    Size $this$run = size;
                    boolean bl = false;
                    for (int i = min; i <= max; i += step) {
                        int n10 = m;
                        m = n10 + 1;
                    }
                    this.fps = new float[m];
                    m = 0;
                    for (int i = min; i <= max; i += step) {
                        Intrinsics.checkNotNull((Object)this.fps);
                        n9 = m;
                        m = n9 + 1;
                        this.fps[n9] = 1.0E7f / (float)i;
                        Intrinsics.checkNotNull((Object)this.fps);
                        n6 = m;
                        m = n6 + 1;
                        float _fps = this.fps[n6];
                    }
                }
                float max_fps = 1.0E7f / (float)min;
                int m = 0;
                Size size = this;
                n6 = 0;
                boolean bl = false;
                Size $this$run = size;
                boolean bl2 = false;
                for (fps = 1.0E7f / (float)min; fps <= max_fps; fps += 1.0f) {
                    n5 = m;
                    m = n5 + 1;
                }
                this.fps = new float[m];
                m = 0;
                size = this;
                n6 = 0;
                bl = false;
                $this$run = size;
                boolean bl3 = false;
                for (fps = 1.0E7f / (float)min; fps <= max_fps; fps += 1.0f) {
                    Intrinsics.checkNotNull((Object)$this$run.fps);
                    n5 = m;
                    m = n5 + 1;
                    $this$run.fps[n5] = fps;
                }
            }
            catch (Exception e) {
                this.fps = null;
            }
        }
        if (this.fps != null) {
            Intrinsics.checkNotNull((Object)this.fps);
            n = this.fps.length;
        } else {
            n = 0;
        }
        int m = n;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int step = 0;
        int n11 = m;
        while (step < n11) {
            void i;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            String string = "%4.1f";
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)this.fps);
            objectArray[0] = Float.valueOf(this.fps[i]);
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            sb.append(string2);
            if (i < m - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        this.frameRates = sb.toString();
        if (this.frameIntervalIndex > m) {
            this.frameIntervalIndex = 0;
        }
    }

    @NotNull
    public String toString() {
        float frame_rate = 0.0f;
        try {
            frame_rate = this.getCurrentFrameRate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.US;
        String string = "Size(%dx%d@%4.1f,type:%d,frame:%d,index:%d,%s)";
        Object[] objectArray = new Object[]{this.width, this.height, Float.valueOf(frame_rate), this.type, this.frame_type, this.index, this.frameRates};
        boolean bl = false;
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        return string2;
    }

    public Size(int _type, int _frame_type, int _index, int _width, int _height) {
        this.fps = new float[0];
        this.type = _type;
        this.frame_type = _frame_type;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        this.frameIntervalType = -1;
        this.frameIntervalIndex = 0;
        this.intervals = null;
        this.updateFrameRate();
    }

    public Size(int _type, int _frame_type, int _index, int _width, int _height, int _min_intervals, int _max_intervals, int _step) {
        this.fps = new float[0];
        this.type = _type;
        this.frame_type = _frame_type;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        this.frameIntervalType = 0;
        this.frameIntervalIndex = 0;
        this.intervals = new int[3];
        Intrinsics.checkNotNull((Object)this.intervals);
        this.intervals[0] = _min_intervals;
        Intrinsics.checkNotNull((Object)this.intervals);
        this.intervals[1] = _max_intervals;
        Intrinsics.checkNotNull((Object)this.intervals);
        this.intervals[2] = _step;
        this.updateFrameRate();
    }

    public Size(int _type, int _frame_type, int _index, int _width, int _height, @Nullable int[] _intervals) {
        int n;
        this.fps = new float[0];
        this.type = _type;
        this.frame_type = _frame_type;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        int n2 = n = _intervals != null ? _intervals.length : -1;
        if (n > 0) {
            this.frameIntervalType = n;
            this.intervals = new int[n];
            Intrinsics.checkNotNull((Object)_intervals);
            System.arraycopy(_intervals, 0, this.intervals, 0, n);
        } else {
            this.frameIntervalType = -1;
            this.intervals = null;
        }
        this.frameIntervalIndex = 0;
        this.updateFrameRate();
    }

    public Size(@NotNull Size other) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.fps = new float[0];
        this.type = other.type;
        this.frame_type = other.frame_type;
        this.index = other.index;
        this.width = other.width;
        this.height = other.height;
        this.frameIntervalType = other.frameIntervalType;
        this.frameIntervalIndex = other.frameIntervalIndex;
        if (other.intervals != null) {
            Intrinsics.checkNotNull((Object)other.intervals);
            n2 = other.intervals.length;
        } else {
            n2 = n = -1;
        }
        if (n > 0) {
            this.intervals = new int[n];
            Intrinsics.checkNotNull((Object)other.intervals);
            System.arraycopy(other.intervals, 0, this.intervals, 0, n);
        } else {
            this.intervals = null;
        }
        this.updateFrameRate();
    }

    private Size(Parcel source) {
        this.fps = new float[0];
        this.type = source.readInt();
        this.frame_type = source.readInt();
        this.index = source.readInt();
        this.width = source.readInt();
        this.height = source.readInt();
        this.frameIntervalType = source.readInt();
        this.frameIntervalIndex = source.readInt();
        if (this.frameIntervalType >= 0) {
            this.intervals = this.frameIntervalType > 0 ? new int[this.frameIntervalType] : new int[3];
            Intrinsics.checkNotNull((Object)this.intervals);
            source.readIntArray(this.intervals);
        } else {
            this.intervals = null;
        }
        this.updateFrameRate();
    }

    static {
        Companion = new Companion(null);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<Size>(){

            @Nullable
            public Size createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new Size(source, null);
            }

            @NotNull
            public Size[] newArray(int size) {
                return new Size[size];
            }
        };
    }

    public /* synthetic */ Size(Parcel source, DefaultConstructorMarker $constructor_marker) {
        this(source);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/bandyer/core_av/usb_camera/internal/Size$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/bandyer/core_av/usb_camera/internal/Size;", "getCREATOR", "()Landroid/os/Parcelable$Creator;", "extension_usb_camera_release"})
    public static final class Companion {
        @NotNull
        public final Parcelable.Creator<Size> getCREATOR() {
            return CREATOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

