/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.core_av.usb_camera.internal;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+BW\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0019\b\u0017\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010%\u001a\u00020\r2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010'\u001a\u00020\u0003H\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010(\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u0000J \u0010(\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\b\u0010*\u001a\u00020\tH\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0013\u0010\u001f\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0011\u0010!\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015R\u0011\u0010#\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/bandyer/core_av/usb_camera/internal/DeviceFilter;", "", "vid", "", "pid", "clasz", "subclass", "protocol", "manufacturer", "", "product", "serialNum", "isExclude", "", "(IIIIILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/hardware/usb/UsbDevice;Z)V", "()Z", "mClass", "getMClass", "()I", "mManufacturerName", "getMManufacturerName", "()Ljava/lang/String;", "mProductId", "getMProductId", "mProductName", "getMProductName", "mProtocol", "getMProtocol", "mSerialNumber", "getMSerialNumber", "mSubclass", "getMSubclass", "mVendorId", "getMVendorId", "equals", "other", "hashCode", "matches", "f", "toString", "Companion", "extension_usb_camera_release"})
public final class DeviceFilter {
    private final int mVendorId;
    private final int mProductId;
    private final int mClass;
    private final int mSubclass;
    private final int mProtocol;
    @Nullable
    private final String mManufacturerName;
    @Nullable
    private final String mProductName;
    @Nullable
    private final String mSerialNumber;
    private final boolean isExclude;
    private static final String TAG = "DeviceFilter";
    public static final Companion Companion = new Companion(null);

    public final int getMVendorId() {
        return this.mVendorId;
    }

    public final int getMProductId() {
        return this.mProductId;
    }

    public final int getMClass() {
        return this.mClass;
    }

    public final int getMSubclass() {
        return this.mSubclass;
    }

    public final int getMProtocol() {
        return this.mProtocol;
    }

    @Nullable
    public final String getMManufacturerName() {
        return this.mManufacturerName;
    }

    @Nullable
    public final String getMProductName() {
        return this.mProductName;
    }

    @Nullable
    public final String getMSerialNumber() {
        return this.mSerialNumber;
    }

    public final boolean isExclude() {
        return this.isExclude;
    }

    private final boolean matches(int clasz, int subclass, int protocol) {
        return !(this.mClass != -1 && clasz != this.mClass || this.mSubclass != -1 && subclass != this.mSubclass || this.mProtocol != -1 && protocol != this.mProtocol);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matches(@NotNull UsbDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        if (this.mVendorId != -1 && device.getVendorId() != this.mVendorId) {
            return false;
        }
        if (this.mProductId != -1 && device.getProductId() != this.mProductId) {
            return false;
        }
        if (device.getDeviceClass() == 0 && device.getDeviceSubclass() == 0) {
            return true;
        }
        if (this.matches(device.getDeviceClass(), device.getDeviceSubclass(), device.getDeviceProtocol())) {
            return true;
        }
        int count = device.getInterfaceCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            UsbInterface intf;
            void i;
            Intrinsics.checkNotNullExpressionValue((Object)device.getInterface((int)i), (String)"device.getInterface(i)");
            if (this.matches(intf.getInterfaceClass(), intf.getInterfaceSubclass(), intf.getInterfaceProtocol())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean isExclude(@NotNull UsbDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return this.isExclude && this.matches(device);
    }

    public final boolean matches(@NotNull DeviceFilter f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (this.isExclude != f.isExclude) {
            return false;
        }
        if (this.mVendorId != -1 && f.mVendorId != this.mVendorId) {
            return false;
        }
        if (this.mProductId != -1 && f.mProductId != this.mProductId) {
            return false;
        }
        if (f.mManufacturerName != null && this.mManufacturerName == null) {
            return false;
        }
        if (f.mProductName != null && this.mProductName == null) {
            return false;
        }
        if (f.mSerialNumber != null && this.mSerialNumber == null) {
            return false;
        }
        if (this.mManufacturerName != null && f.mManufacturerName != null && Intrinsics.areEqual((Object)this.mManufacturerName, (Object)f.mManufacturerName) ^ true) {
            return false;
        }
        if (this.mProductName != null && f.mProductName != null && Intrinsics.areEqual((Object)this.mProductName, (Object)f.mProductName) ^ true) {
            return false;
        }
        return this.mSerialNumber != null && f.mSerialNumber != null && Intrinsics.areEqual((Object)this.mSerialNumber, (Object)f.mSerialNumber) ^ true ? false : this.matches(f.mClass, f.mSubclass, f.mProtocol);
    }

    public boolean equals(@Nullable Object other) {
        if (this.mVendorId == -1 || this.mProductId == -1 || this.mClass == -1 || this.mSubclass == -1 || this.mProtocol == -1) {
            return false;
        }
        if (other instanceof DeviceFilter) {
            Object filter = other;
            if (((DeviceFilter)filter).mVendorId != this.mVendorId || ((DeviceFilter)filter).mProductId != this.mProductId || ((DeviceFilter)filter).mClass != this.mClass || ((DeviceFilter)filter).mSubclass != this.mSubclass || ((DeviceFilter)filter).mProtocol != this.mProtocol) {
                return false;
            }
            if (((DeviceFilter)filter).mManufacturerName != null && this.mManufacturerName == null || ((DeviceFilter)filter).mManufacturerName == null && this.mManufacturerName != null || ((DeviceFilter)filter).mProductName != null && this.mProductName == null || ((DeviceFilter)filter).mProductName == null && this.mProductName != null || ((DeviceFilter)filter).mSerialNumber != null && this.mSerialNumber == null || ((DeviceFilter)filter).mSerialNumber == null && this.mSerialNumber != null) {
                return false;
            }
            return ((DeviceFilter)filter).mManufacturerName != null && this.mManufacturerName != null && Intrinsics.areEqual((Object)this.mManufacturerName, (Object)((DeviceFilter)filter).mManufacturerName) ^ true || ((DeviceFilter)filter).mProductName != null && this.mProductName != null && Intrinsics.areEqual((Object)this.mProductName, (Object)((DeviceFilter)filter).mProductName) ^ true || ((DeviceFilter)filter).mSerialNumber != null && this.mSerialNumber != null && Intrinsics.areEqual((Object)this.mSerialNumber, (Object)((DeviceFilter)filter).mSerialNumber) ^ true ? false : ((DeviceFilter)filter).isExclude != this.isExclude;
        }
        if (other instanceof UsbDevice) {
            return !this.isExclude && ((UsbDevice)other).getVendorId() == this.mVendorId && ((UsbDevice)other).getProductId() == this.mProductId && ((UsbDevice)other).getDeviceClass() == this.mClass && ((UsbDevice)other).getDeviceSubclass() == this.mSubclass && ((UsbDevice)other).getDeviceProtocol() == this.mProtocol;
        }
        return false;
    }

    public int hashCode() {
        return (this.mVendorId << 16 | this.mProductId) ^ (this.mClass << 16 | this.mSubclass << 8 | this.mProtocol);
    }

    @NotNull
    public String toString() {
        return "DeviceFilter[mVendorId=" + this.mVendorId + ",mProductId=" + this.mProductId + ",mClass=" + this.mClass + ",mSubclass=" + this.mSubclass + ",mProtocol=" + this.mProtocol + ",mManufacturerName=" + this.mManufacturerName + ",mProductName=" + this.mProductName + ",mSerialNumber=" + this.mSerialNumber + ",isExclude=" + this.isExclude + "]";
    }

    @JvmOverloads
    public DeviceFilter(int vid, int pid, int clasz, int subclass, int protocol, @Nullable String manufacturer, @Nullable String product, @Nullable String serialNum, boolean isExclude) {
        this.mVendorId = vid;
        this.mProductId = pid;
        this.mClass = clasz;
        this.mSubclass = subclass;
        this.mProtocol = protocol;
        this.mManufacturerName = manufacturer;
        this.mProductName = product;
        this.mSerialNumber = serialNum;
        this.isExclude = isExclude;
    }

    public /* synthetic */ DeviceFilter(int n, int n2, int n3, int n4, int n5, String string, String string2, String string3, boolean bl, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 0x100) != 0) {
            bl = false;
        }
        this(n, n2, n3, n4, n5, string, string2, string3, bl);
    }

    @JvmOverloads
    public DeviceFilter(int vid, int pid, int clasz, int subclass, int protocol, @Nullable String manufacturer, @Nullable String product, @Nullable String serialNum) {
        this(vid, pid, clasz, subclass, protocol, manufacturer, product, serialNum, false, 256, null);
    }

    @JvmOverloads
    public DeviceFilter(@NotNull UsbDevice device, boolean isExclude) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.mVendorId = device.getVendorId();
        this.mProductId = device.getProductId();
        this.mClass = device.getDeviceClass();
        this.mSubclass = device.getDeviceSubclass();
        this.mProtocol = device.getDeviceProtocol();
        this.mManufacturerName = null;
        this.mProductName = null;
        this.mSerialNumber = null;
        this.isExclude = isExclude;
    }

    public /* synthetic */ DeviceFilter(UsbDevice usbDevice, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(usbDevice, bl);
    }

    @JvmOverloads
    public DeviceFilter(@NotNull UsbDevice device) {
        this(device, false, 2, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0002J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000fH\u0002J6\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/bandyer/core_av/usb_camera/internal/DeviceFilter$Companion;", "", "()V", "TAG", "", "getAttributeBoolean", "", "context", "Landroid/content/Context;", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "namespace", "name", "defaultValue", "getAttributeInteger", "", "getAttributeString", "getDeviceFilters", "", "Lcom/bandyer/core_av/usb_camera/internal/DeviceFilter;", "deviceFilterXmlId", "readEntryOne", "extension_usb_camera_release"})
    public static final class Companion {
        @NotNull
        public final List<DeviceFilter> getDeviceFilters(@NotNull Context context, int deviceFilterXmlId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            XmlResourceParser xmlResourceParser = context.getResources().getXml(deviceFilterXmlId);
            Intrinsics.checkNotNullExpressionValue((Object)xmlResourceParser, (String)"context.resources.getXml(deviceFilterXmlId)");
            XmlPullParser parser = (XmlPullParser)xmlResourceParser;
            List deviceFilters = new ArrayList();
            try {
                int eventType = parser.getEventType();
                while (eventType != 1) {
                    DeviceFilter deviceFilter;
                    if (eventType == 2 && (deviceFilter = this.readEntryOne(context, parser)) != null) {
                        deviceFilters.add(deviceFilter);
                    }
                    eventType = parser.next();
                }
            }
            catch (XmlPullParserException e) {
                Log.d((String)DeviceFilter.TAG, (String)"XmlPullParserException", (Throwable)e);
            }
            catch (IOException e) {
                Log.d((String)DeviceFilter.TAG, (String)"IOException", (Throwable)e);
            }
            List<DeviceFilter> list = Collections.unmodifiableList(deviceFilters);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.unmodifiableList(deviceFilters)");
            return list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final int getAttributeInteger(Context context, XmlPullParser parser, String namespace, String name, int defaultValue) {
            int result = defaultValue;
            try {
                int n;
                String string;
                String v = parser.getAttributeValue(namespace, name);
                if (!TextUtils.isEmpty((CharSequence)v)) {
                    String string2 = v;
                    Intrinsics.checkNotNull((Object)string2);
                    if (StringsKt.startsWith$default((String)string2, (String)"@", (boolean)false, (int)2, null)) {
                        String string3 = v;
                        int n2 = 1;
                        boolean bl = false;
                        String string4 = string3.substring(n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        String r = string4;
                        int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
                        if (resId <= 0) return result;
                        return context.getResources().getInteger(resId);
                    }
                }
                int radix = 10;
                if (v != null && v.length() > 2 && v.charAt(0) == '0' && (v.charAt(1) == 'x' || v.charAt(1) == 'X')) {
                    radix = 16;
                    string = v;
                    n = 2;
                    boolean bl = false;
                    String string5 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    v = string5;
                }
                String string6 = v;
                Intrinsics.checkNotNull((Object)string6);
                string = string6;
                n = 0;
                return Integer.parseInt(string, CharsKt.checkRadix((int)radix));
            }
            catch (Resources.NotFoundException e) {
                return defaultValue;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
            catch (NullPointerException e) {
                return defaultValue;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean getAttributeBoolean(Context context, XmlPullParser parser, String namespace, String name, boolean defaultValue) {
            boolean result = defaultValue;
            try {
                boolean bl;
                String v = parser.getAttributeValue(namespace, name);
                if (StringsKt.equals((String)"TRUE", (String)v, (boolean)true)) {
                    return true;
                }
                if (StringsKt.equals((String)"FALSE", (String)v, (boolean)true)) {
                    return false;
                }
                if (!TextUtils.isEmpty((CharSequence)v)) {
                    String string = v;
                    Intrinsics.checkNotNull((Object)string);
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) {
                        String string2 = v;
                        int n = 1;
                        boolean bl2 = false;
                        String string3 = string2.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        String r = string3;
                        int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
                        if (resId <= 0) return result;
                        return context.getResources().getBoolean(resId);
                    }
                }
                int radix = 10;
                if (v != null && v.length() > 2 && v.charAt(0) == '0' && (v.charAt(1) == 'x' || v.charAt(1) == 'X')) {
                    radix = 16;
                    String resId = v;
                    int n = 2;
                    bl = false;
                    String string = resId.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                    v = string;
                }
                String string = v;
                Intrinsics.checkNotNull((Object)string);
                String string4 = string;
                bl = false;
                int val = Integer.parseInt(string4, CharsKt.checkRadix((int)radix));
                if (val == 0) return false;
                return true;
            }
            catch (Resources.NotFoundException e) {
                return defaultValue;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
            catch (NullPointerException e) {
                return defaultValue;
            }
        }

        private final String getAttributeString(Context context, XmlPullParser parser, String namespace, String name, String defaultValue) {
            String result = defaultValue;
            try {
                result = parser.getAttributeValue(namespace, name);
                if (result == null) {
                    result = defaultValue;
                }
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    String string = result;
                    Intrinsics.checkNotNull((Object)string);
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) {
                        String string2 = result;
                        int n = 1;
                        boolean bl = false;
                        String string3 = string2.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        String r = string3;
                        int resId = context.getResources().getIdentifier(r, null, context.getPackageName());
                        if (resId > 0) {
                            result = context.getResources().getString(resId);
                        }
                    }
                }
            }
            catch (Resources.NotFoundException e) {
                result = defaultValue;
            }
            catch (NumberFormatException e) {
                result = defaultValue;
            }
            catch (NullPointerException e) {
                result = defaultValue;
            }
            return result;
        }

        @Nullable
        public final DeviceFilter readEntryOne(@NotNull Context context, @NotNull XmlPullParser parser) throws XmlPullParserException, IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            int vendorId = -1;
            int productId = -1;
            int deviceClass = -1;
            int deviceSubclass = -1;
            int deviceProtocol = -1;
            boolean exclude = false;
            String manufacturerName = null;
            String productName = null;
            String serialNumber = null;
            boolean hasValue = false;
            String tag = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                Intrinsics.checkNotNullExpressionValue((Object)parser.getName(), (String)"parser.name");
                if (!TextUtils.isEmpty((CharSequence)tag) && StringsKt.equals((String)tag, (String)"usb-device", (boolean)true)) {
                    if (eventType == 2) {
                        hasValue = true;
                        vendorId = this.getAttributeInteger(context, parser, null, "vendor-id", -1);
                        if (vendorId == -1 && (vendorId = this.getAttributeInteger(context, parser, null, "vendorId", -1)) == -1) {
                            vendorId = this.getAttributeInteger(context, parser, null, "venderId", -1);
                        }
                        if ((productId = this.getAttributeInteger(context, parser, null, "product-id", -1)) == -1) {
                            productId = this.getAttributeInteger(context, parser, null, "productId", -1);
                        }
                        deviceClass = this.getAttributeInteger(context, parser, null, "class", -1);
                        deviceSubclass = this.getAttributeInteger(context, parser, null, "subclass", -1);
                        deviceProtocol = this.getAttributeInteger(context, parser, null, "protocol", -1);
                        manufacturerName = this.getAttributeString(context, parser, null, "manufacturer-name", null);
                        if (TextUtils.isEmpty((CharSequence)manufacturerName)) {
                            manufacturerName = this.getAttributeString(context, parser, null, "manufacture", null);
                        }
                        if (TextUtils.isEmpty((CharSequence)(productName = this.getAttributeString(context, parser, null, "product-name", null)))) {
                            productName = this.getAttributeString(context, parser, null, "product", null);
                        }
                        if (TextUtils.isEmpty((CharSequence)(serialNumber = this.getAttributeString(context, parser, null, "serial-number", null)))) {
                            serialNumber = this.getAttributeString(context, parser, null, "serial", null);
                        }
                        exclude = this.getAttributeBoolean(context, parser, null, "exclude", false);
                    } else if (eventType == 3 && hasValue) {
                        return new DeviceFilter(vendorId, productId, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, serialNumber, exclude);
                    }
                }
                eventType = parser.next();
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

