/*
 * Decompiled with CFR 0.152.
 */
package com.bandyer.core_av.usb_camera.internal;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.bandyer.core_av.usb_camera.OnDeviceConnectListener;
import com.bandyer.core_av.usb_camera.UsbConnector;
import com.bandyer.core_av.usb_camera.UsbData;
import com.bandyer.core_av.usb_camera.UsbDeviceExtensionsKt;
import com.bandyer.core_av.usb_camera.UsbDeviceInfo;
import com.bandyer.core_av.usb_camera.internal.BaseUsbConnector;
import com.bandyer.core_av.usb_camera.internal.BaseUsbData;
import com.bandyer.core_av.usb_camera.internal.DeviceFilter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 W2\u00020\u0001:\u0001WB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020!J\u0016\u0010A\u001a\u00020B2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u0010J\b\u0010E\u001a\u00020BH\u0016J\u0006\u0010F\u001a\u00020BJ\u000e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010C\u001a\u0004\u0018\u00010!J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u0010J\u0010\u0010J\u001a\u00020\n2\b\u0010I\u001a\u0004\u0018\u00010\u0011J\u000e\u0010K\u001a\u00020L2\u0006\u0010I\u001a\u00020\u0011J\u0010\u0010M\u001a\u00020B2\u0006\u0010I\u001a\u00020\u0011H\u0002J\u0012\u0010N\u001a\u00020B2\b\u0010I\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010O\u001a\u00020B2\u0006\u0010I\u001a\u00020\u0011H\u0002J\u0010\u0010P\u001a\u00020B2\u0006\u0010I\u001a\u00020\u0011H\u0002J\b\u0010Q\u001a\u00020BH\u0016J\u000e\u0010R\u001a\u00020B2\u0006\u0010C\u001a\u00020!J\u0016\u0010R\u001a\u00020B2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u0010J\u0010\u0010S\u001a\u00020\n2\u0006\u0010I\u001a\u00020\u0011H\u0016J\u000e\u0010T\u001a\u00020B2\u0006\u0010C\u001a\u00020!J\u0016\u0010T\u001a\u00020B2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u0010J\b\u0010U\u001a\u00020BH\u0016J\u001a\u0010V\u001a\u00020\n2\b\u0010I\u001a\u0004\u0018\u00010\u00112\u0006\u0010J\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013R!\u0010#\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010%0$\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u00103\u001a\u000204\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00109\u001a\b\u0012\u0004\u0012\u00020\u00030%\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u001f\u0010<\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020>0=\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@\u00a8\u0006X"}, d2={"Lcom/bandyer/core_av/usb_camera/internal/BaseUsbConnector;", "Lcom/bandyer/core_av/usb_camera/UsbConnector;", "context", "Landroid/content/Context;", "listener", "Lcom/bandyer/core_av/usb_camera/OnDeviceConnectListener;", "(Landroid/content/Context;Lcom/bandyer/core_av/usb_camera/OnDeviceConnectListener;)V", "ACTION_USB_PERMISSION", "", "destroyed", "", "deviceCount", "", "getDeviceCount", "()I", "deviceList", "", "Landroid/hardware/usb/UsbDevice;", "getDeviceList", "()Ljava/util/List;", "devices", "", "getDevices", "()Ljava/util/Iterator;", "isRegistered", "()Z", "mAsyncHandler", "Landroid/os/Handler;", "mDeviceCheckRunnable", "Ljava/lang/Runnable;", "mDeviceCounts", "mDeviceFilters", "", "Lcom/bandyer/core_av/usb_camera/internal/DeviceFilter;", "getMDeviceFilters", "mHasPermissions", "Landroid/util/SparseArray;", "Ljava/lang/ref/WeakReference;", "getMHasPermissions", "()Landroid/util/SparseArray;", "mOnDeviceConnectListener", "getMOnDeviceConnectListener", "()Lcom/bandyer/core_av/usb_camera/OnDeviceConnectListener;", "setMOnDeviceConnectListener", "(Lcom/bandyer/core_av/usb_camera/OnDeviceConnectListener;)V", "mPermissionIntent", "Landroid/app/PendingIntent;", "getMPermissionIntent", "()Landroid/app/PendingIntent;", "setMPermissionIntent", "(Landroid/app/PendingIntent;)V", "mUsbManager", "Landroid/hardware/usb/UsbManager;", "getMUsbManager", "()Landroid/hardware/usb/UsbManager;", "mUsbReceiver", "Landroid/content/BroadcastReceiver;", "mWeakContext", "getMWeakContext", "()Ljava/lang/ref/WeakReference;", "musbDatas", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/bandyer/core_av/usb_camera/internal/BaseUsbData;", "getMusbDatas", "()Ljava/util/concurrent/ConcurrentHashMap;", "addDeviceFilter", "", "filter", "filters", "destroy", "dumpDevices", "getDeviceInfo", "Lcom/bandyer/core_av/usb_camera/UsbDeviceInfo;", "device", "hasPermission", "openDevice", "Lcom/bandyer/core_av/usb_camera/UsbData;", "processAttach", "processCancel", "processConnect", "processDettach", "register", "removeDeviceFilter", "requestPermission", "setDeviceFilter", "unregister", "updatePermission", "Companion", "extension_usb_camera_release"})
public final class BaseUsbConnector
implements UsbConnector {
    private final String ACTION_USB_PERMISSION;
    @NotNull
    private final ConcurrentHashMap<UsbDevice, BaseUsbData> musbDatas;
    @NotNull
    private final SparseArray<WeakReference<UsbDevice>> mHasPermissions;
    @NotNull
    private final WeakReference<Context> mWeakContext;
    @NotNull
    private final UsbManager mUsbManager;
    @Nullable
    private OnDeviceConnectListener mOnDeviceConnectListener;
    @Nullable
    private PendingIntent mPermissionIntent;
    @NotNull
    private final List<DeviceFilter> mDeviceFilters;
    private Handler mAsyncHandler;
    private volatile boolean destroyed;
    private final BroadcastReceiver mUsbReceiver;
    private volatile int mDeviceCounts;
    private final Runnable mDeviceCheckRunnable;
    private static final boolean DEBUG;
    private static final String TAG;
    private static final String ACTION_USB_PERMISSION_BASE;
    @NotNull
    private static final String ACTION_USB_DEVICE_ATTACHED;
    public static final Companion Companion;

    @NotNull
    public final ConcurrentHashMap<UsbDevice, BaseUsbData> getMusbDatas() {
        return this.musbDatas;
    }

    @NotNull
    public final SparseArray<WeakReference<UsbDevice>> getMHasPermissions() {
        return this.mHasPermissions;
    }

    @NotNull
    public final WeakReference<Context> getMWeakContext() {
        return this.mWeakContext;
    }

    @NotNull
    public final UsbManager getMUsbManager() {
        return this.mUsbManager;
    }

    @Nullable
    public final OnDeviceConnectListener getMOnDeviceConnectListener() {
        return this.mOnDeviceConnectListener;
    }

    public final void setMOnDeviceConnectListener(@Nullable OnDeviceConnectListener onDeviceConnectListener) {
        this.mOnDeviceConnectListener = onDeviceConnectListener;
    }

    @Nullable
    public final PendingIntent getMPermissionIntent() {
        return this.mPermissionIntent;
    }

    public final void setMPermissionIntent(@Nullable PendingIntent pendingIntent) {
        this.mPermissionIntent = pendingIntent;
    }

    @NotNull
    public final List<DeviceFilter> getMDeviceFilters() {
        return this.mDeviceFilters;
    }

    @Override
    public void destroy() {
        if (DEBUG) {
            Log.i((String)TAG, (String)"destroy:");
        }
        this.unregister();
        if (!this.destroyed) {
            this.destroyed = true;
            Set set = this.musbDatas.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"musbDatas.keys");
            Set keys = set;
            if (keys != null) {
                BaseUsbData usbData = null;
                try {
                    for (UsbDevice key : keys) {
                        Map map = this.musbDatas;
                        boolean bl = false;
                        Map map2 = map;
                        if (map2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                        }
                        BaseUsbData baseUsbData = usbData = (BaseUsbData)TypeIntrinsics.asMutableMap((Object)map2).remove(key);
                        if (baseUsbData == null) continue;
                        baseUsbData.close();
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"destroy:", (Throwable)e);
                }
            }
            this.musbDatas.clear();
            try {
                Handler handler = this.mAsyncHandler;
                if (handler == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mAsyncHandler");
                }
                handler.getLooper().quit();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"destroy:", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void register() throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        if (this.mPermissionIntent == null) {
            Context context;
            if (DEBUG) {
                Log.i((String)TAG, (String)"register:");
            }
            if ((context = (Context)this.mWeakContext.get()) != null) {
                this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
                IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                context.registerReceiver(this.mUsbReceiver, filter);
            }
            this.mDeviceCounts = 0;
            Handler handler = this.mAsyncHandler;
            if (handler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAsyncHandler");
            }
            handler.postDelayed(this.mDeviceCheckRunnable, 1000L);
        }
    }

    @Override
    public synchronized void unregister() throws IllegalStateException {
        this.mDeviceCounts = 0;
        if (!this.destroyed) {
            Handler handler = this.mAsyncHandler;
            if (handler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mAsyncHandler");
            }
            handler.removeCallbacks(this.mDeviceCheckRunnable);
        }
        if (this.mPermissionIntent != null) {
            Context context = (Context)this.mWeakContext.get();
            try {
                Context context2 = context;
                if (context2 != null) {
                    context2.unregisterReceiver(this.mUsbReceiver);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mPermissionIntent = null;
        }
    }

    public final synchronized boolean isRegistered() {
        return !this.destroyed && this.mPermissionIntent != null;
    }

    public final void setDeviceFilter(@NotNull DeviceFilter filter) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.clear();
        this.mDeviceFilters.add(filter);
    }

    public final void addDeviceFilter(@NotNull DeviceFilter filter) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.add(filter);
    }

    public final void removeDeviceFilter(@NotNull DeviceFilter filter) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.remove(filter);
    }

    public final void setDeviceFilter(@Nullable List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.clear();
        List<DeviceFilter> list = filters;
        Intrinsics.checkNotNull(list);
        this.mDeviceFilters.addAll((Collection<DeviceFilter>)list);
    }

    public final void addDeviceFilter(@Nullable List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        List<DeviceFilter> list = filters;
        Intrinsics.checkNotNull(list);
        this.mDeviceFilters.addAll((Collection<DeviceFilter>)list);
    }

    public final void removeDeviceFilter(@Nullable List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        List<DeviceFilter> list = filters;
        Intrinsics.checkNotNull(list);
        this.mDeviceFilters.removeAll((Collection)list);
    }

    public final int getDeviceCount() throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        return this.getDeviceList().size();
    }

    @NotNull
    public final List<UsbDevice> getDeviceList() throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        return this.getDeviceList(this.mDeviceFilters);
    }

    @NotNull
    public final List<UsbDevice> getDeviceList(@Nullable List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        List result = new ArrayList();
        if (deviceList != null) {
            if (filters == null || filters.isEmpty()) {
                Collection collection = deviceList.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"deviceList.values");
                result.addAll(collection);
            } else {
                block0: for (UsbDevice device : deviceList.values()) {
                    for (DeviceFilter filter : filters) {
                        if (filter == null || !filter.matches(device)) continue;
                        if (filter.isExclude()) continue block0;
                        result.add(device);
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    @NotNull
    public final List<UsbDevice> getDeviceList(@Nullable DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        List result = new ArrayList();
        if (deviceList != null) {
            for (UsbDevice device : deviceList.values()) {
                if (filter != null && (!filter.matches(device) || filter.isExclude())) continue;
                result.add(device);
            }
        }
        return result;
    }

    @Nullable
    public final Iterator<UsbDevice> getDevices() throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        Iterator iterator = null;
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            iterator = list.values().iterator();
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    public final void dumpDevices() {
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            Set set = list.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"list.keys");
            Set keys = set;
            if (keys != null && keys.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    UsbDevice device;
                    UsbDevice usbDevice = device = (UsbDevice)list.get(key);
                    int num_interface = usbDevice != null ? usbDevice.getInterfaceCount() : 0;
                    sb.setLength(0);
                    int n = 0;
                    int n2 = num_interface;
                    while (n < n2) {
                        void i;
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        Locale locale = Locale.US;
                        String string = "interface%d:%s";
                        Object[] objectArray = new Object[2];
                        objectArray[0] = (int)i;
                        UsbDevice usbDevice2 = device;
                        Intrinsics.checkNotNull((Object)usbDevice2);
                        objectArray[1] = usbDevice2.getInterface((int)i).toString();
                        Object[] objectArray2 = objectArray;
                        boolean bl = false;
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
                        sb.append(string2);
                        ++i;
                    }
                    Log.i((String)TAG, (String)("key=" + key + ':' + device + ':' + sb));
                }
            } else {
                Log.i((String)TAG, (String)"no device");
            }
        } else {
            Log.i((String)TAG, (String)"no device");
        }
    }

    public final boolean hasPermission(@Nullable UsbDevice device) throws IllegalStateException {
        if (this.destroyed) {
            throw (Throwable)new IllegalStateException("already destroyed");
        }
        return this.updatePermission(device, device != null && this.mUsbManager.hasPermission(device));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean updatePermission(UsbDevice device, boolean hasPermission) {
        int deviceKey = Companion.getDeviceKey(device, false);
        SparseArray<WeakReference<UsbDevice>> sparseArray = this.mHasPermissions;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sparseArray) {
            boolean bl3 = false;
            if (hasPermission) {
                if (this.mHasPermissions.get(deviceKey) == null) {
                    this.mHasPermissions.put(deviceKey, new WeakReference<UsbDevice>(device));
                }
            } else {
                this.mHasPermissions.remove(deviceKey);
            }
            Unit unit = Unit.INSTANCE;
        }
        return hasPermission;
    }

    @Override
    public synchronized boolean requestPermission(@NotNull UsbDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        boolean result = false;
        if (this.isRegistered()) {
            if (this.mUsbManager.hasPermission(device)) {
                this.processConnect(device);
            } else {
                try {
                    this.mUsbManager.requestPermission(device, this.mPermissionIntent);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                    this.processCancel(device);
                    result = true;
                }
            }
        } else {
            this.processCancel(device);
            result = true;
        }
        return result;
    }

    @NotNull
    public final UsbData openDevice(@NotNull UsbDevice device) throws SecurityException {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        if (this.hasPermission(device)) {
            BaseUsbData result = this.musbDatas.get(device);
            if (result == null) {
                Object t = this.mWeakContext.get();
                Intrinsics.checkNotNull(t);
                Intrinsics.checkNotNullExpressionValue(t, (String)"mWeakContext.get()!!");
                result = new BaseUsbData((Context)t, this, device);
                ((Map)this.musbDatas).put(device, result);
            }
            return result;
        }
        throw (Throwable)new SecurityException("has no permission");
    }

    private final void processConnect(UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        this.updatePermission(device, true);
        Handler handler = this.mAsyncHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAsyncHandler");
        }
        handler.post(new Runnable(this, device){
            final /* synthetic */ BaseUsbConnector this$0;
            final /* synthetic */ UsbDevice $device;

            public final void run() {
                block2: {
                    if (BaseUsbConnector.access$getDEBUG$cp()) {
                        Log.v((String)BaseUsbConnector.access$getTAG$cp(), (String)("processConnect:device=" + this.$device));
                    }
                    UsbData usbData = null;
                    boolean createNew = false;
                    usbData = this.this$0.getMusbDatas().get(this.$device);
                    if (usbData == null) {
                        T t = this.this$0.getMWeakContext().get();
                        Intrinsics.checkNotNull(t);
                        Intrinsics.checkNotNullExpressionValue(t, (String)"mWeakContext.get()!!");
                        usbData = new BaseUsbData((Context)t, this.this$0, this.$device);
                        ((Map)this.this$0.getMusbDatas()).put(this.$device, usbData);
                    }
                    OnDeviceConnectListener onDeviceConnectListener = this.this$0.getMOnDeviceConnectListener();
                    if (onDeviceConnectListener == null) break block2;
                    onDeviceConnectListener.onDeviceUsageGranted(this.$device, usbData);
                }
            }
            {
                this.this$0 = baseUsbConnector;
                this.$device = usbDevice;
            }
        });
    }

    private final void processCancel(UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"processCancel:");
        }
        this.updatePermission(device, false);
        if (this.mOnDeviceConnectListener == null) {
            return;
        }
        Handler handler = this.mAsyncHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAsyncHandler");
        }
        handler.post(new Runnable(this, device){
            final /* synthetic */ BaseUsbConnector this$0;
            final /* synthetic */ UsbDevice $device;

            public final void run() {
                block0: {
                    OnDeviceConnectListener onDeviceConnectListener = this.this$0.getMOnDeviceConnectListener();
                    if (onDeviceConnectListener == null) break block0;
                    onDeviceConnectListener.onDeviceUsageDenied(this.$device);
                }
            }
            {
                this.this$0 = baseUsbConnector;
                this.$device = usbDevice;
            }
        });
    }

    private final void processAttach(UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"processAttach:");
        }
        if (this.mOnDeviceConnectListener == null) {
            return;
        }
        if (device.getDeviceClass() != 14 && device.getDeviceClass() != 239) {
            return;
        }
        Handler handler = this.mAsyncHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAsyncHandler");
        }
        handler.post(new Runnable(this, device){
            final /* synthetic */ BaseUsbConnector this$0;
            final /* synthetic */ UsbDevice $device;

            public final void run() {
                block0: {
                    OnDeviceConnectListener onDeviceConnectListener = this.this$0.getMOnDeviceConnectListener();
                    if (onDeviceConnectListener == null) break block0;
                    onDeviceConnectListener.onAttach(this.$device);
                }
            }
            {
                this.this$0 = baseUsbConnector;
                this.$device = usbDevice;
            }
        });
    }

    private final void processDettach(UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"processDettach:");
        }
        if (this.mOnDeviceConnectListener == null) {
            return;
        }
        Handler handler = this.mAsyncHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAsyncHandler");
        }
        handler.post(new Runnable(this, device){
            final /* synthetic */ BaseUsbConnector this$0;
            final /* synthetic */ UsbDevice $device;

            public final void run() {
                block0: {
                    OnDeviceConnectListener onDeviceConnectListener = this.this$0.getMOnDeviceConnectListener();
                    if (onDeviceConnectListener == null) break block0;
                    onDeviceConnectListener.onDetach(this.$device);
                }
            }
            {
                this.this$0 = baseUsbConnector;
                this.$device = usbDevice;
            }
        });
    }

    @NotNull
    public final UsbDeviceInfo getDeviceInfo(@NotNull UsbDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return Companion.updateDeviceInfo(this.mUsbManager, device);
    }

    public BaseUsbConnector(@NotNull Context context, @NotNull OnDeviceConnectListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.ACTION_USB_PERMISSION = ACTION_USB_PERMISSION_BASE + this.hashCode();
        this.musbDatas = new ConcurrentHashMap();
        this.mHasPermissions = new SparseArray();
        this.mDeviceFilters = new ArrayList();
        this.mUsbReceiver = new BroadcastReceiver(this){
            final /* synthetic */ BaseUsbConnector this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                UsbDevice device;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                if (BaseUsbConnector.access$getDestroyed$p(this.this$0)) {
                    return;
                }
                String action = intent.getAction();
                if (Intrinsics.areEqual((Object)BaseUsbConnector.access$getACTION_USB_PERMISSION$p(this.this$0), (Object)action)) {
                    BaseUsbConnector baseUsbConnector = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (baseUsbConnector) {
                        boolean bl3 = false;
                        UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
                        if (intent.getBooleanExtra("permission", false)) {
                            if (device2 != null) {
                                BaseUsbConnector.access$processConnect(this.this$0, device2);
                            }
                        } else {
                            BaseUsbConnector.access$processCancel(this.this$0, device2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                } else if (Intrinsics.areEqual((Object)"android.hardware.usb.action.USB_DEVICE_ATTACHED", (Object)action)) {
                    Parcelable parcelable = intent.getParcelableExtra("device");
                    Intrinsics.checkNotNull((Object)parcelable);
                    Intrinsics.checkNotNullExpressionValue((Object)parcelable, (String)"intent.getParcelableExtr\u2026sbManager.EXTRA_DEVICE)!!");
                    UsbDevice device3 = (UsbDevice)parcelable;
                    BaseUsbConnector.access$updatePermission(this.this$0, device3, this.this$0.hasPermission(device3));
                    BaseUsbConnector.access$processAttach(this.this$0, device3);
                } else if (Intrinsics.areEqual((Object)"android.hardware.usb.action.USB_DEVICE_DETACHED", (Object)action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                    BaseUsbData usbData;
                    BaseUsbData baseUsbData = usbData = this.this$0.getMusbDatas().get(device);
                    if (baseUsbData != null) {
                        baseUsbData.close();
                    }
                    BaseUsbConnector.access$setMDeviceCounts$p(this.this$0, 0);
                    BaseUsbConnector.access$processDettach(this.this$0, device);
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.mDeviceCheckRunnable = new Runnable(this){
            final /* synthetic */ BaseUsbConnector this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (BaseUsbConnector.access$getDestroyed$p(this.this$0)) {
                    return;
                }
                List<UsbDevice> devices = this.this$0.getDeviceList();
                int n = devices.size();
                int hasPermissionCounts = 0;
                int m = 0;
                Object object = this.this$0.getMHasPermissions();
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    hasPermissionCounts = this.this$0.getMHasPermissions().size();
                    this.this$0.getMHasPermissions().clear();
                    for (UsbDevice device : devices) {
                        this.this$0.hasPermission(device);
                    }
                    m = this.this$0.getMHasPermissions().size();
                    Unit unit = Unit.INSTANCE;
                }
                if (n > BaseUsbConnector.access$getMDeviceCounts$p(this.this$0) || m > hasPermissionCounts) {
                    BaseUsbConnector.access$setMDeviceCounts$p(this.this$0, n);
                    OnDeviceConnectListener onDeviceConnectListener = this.this$0.getMOnDeviceConnectListener();
                    if (onDeviceConnectListener != null) {
                        object = onDeviceConnectListener;
                        bl = false;
                        boolean bl4 = false;
                        Object it = object;
                        boolean bl5 = false;
                        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)n);
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int i = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl6 = false;
                            UsbDevice device = devices.get(i);
                            if (device.getDeviceClass() != 14 && device.getDeviceClass() != 239) continue;
                            BaseUsbConnector.access$getMAsyncHandler$p(this.this$0).post(new Runnable(device, (OnDeviceConnectListener)it, this, n, devices){
                                final /* synthetic */ UsbDevice $device;
                                final /* synthetic */ OnDeviceConnectListener $it$inlined;
                                final /* synthetic */ mDeviceCheckRunnable.1 this$0;
                                final /* synthetic */ int $n$inlined;
                                final /* synthetic */ List $devices$inlined;
                                {
                                    this.$device = usbDevice;
                                    this.$it$inlined = onDeviceConnectListener;
                                    this.this$0 = var3_3;
                                    this.$n$inlined = n;
                                    this.$devices$inlined = list;
                                }

                                public final void run() {
                                    this.$it$inlined.onAttach(this.$device);
                                }
                            });
                        }
                    }
                }
                BaseUsbConnector.access$getMAsyncHandler$p(this.this$0).postDelayed((Runnable)this, 2000L);
            }
            {
                this.this$0 = this$0;
            }
        };
        if (DEBUG) {
            Log.v((String)TAG, (String)"USBMonitor:Constructor");
        }
        this.mWeakContext = new WeakReference<Context>(context);
        Object object = context.getSystemService("usb");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.usb.UsbManager");
        }
        this.mUsbManager = (UsbManager)object;
        this.mOnDeviceConnectListener = listener;
        HandlerThread handlerThread = new HandlerThread("UsbMonitor");
        boolean bl = false;
        boolean bl2 = false;
        HandlerThread it = handlerThread;
        boolean bl3 = false;
        it.start();
        HandlerThread thread = handlerThread;
        this.mAsyncHandler = new Handler(thread.getLooper());
        this.destroyed = false;
        if (DEBUG) {
            Log.v((String)TAG, (String)("USBMonitor:mUsbManager=" + this.mUsbManager));
        }
    }

    static {
        Companion = new Companion(null);
        TAG = "USBMonitor";
        ACTION_USB_PERMISSION_BASE = "com.serenegiant.USB_PERMISSION.";
        ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    }

    public static final /* synthetic */ boolean access$getDEBUG$cp() {
        return DEBUG;
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ boolean access$getDestroyed$p(BaseUsbConnector $this) {
        return $this.destroyed;
    }

    public static final /* synthetic */ void access$setDestroyed$p(BaseUsbConnector $this, boolean bl) {
        $this.destroyed = bl;
    }

    public static final /* synthetic */ String access$getACTION_USB_PERMISSION$p(BaseUsbConnector $this) {
        return $this.ACTION_USB_PERMISSION;
    }

    public static final /* synthetic */ void access$processConnect(BaseUsbConnector $this, UsbDevice device) {
        $this.processConnect(device);
    }

    public static final /* synthetic */ void access$processCancel(BaseUsbConnector $this, UsbDevice device) {
        $this.processCancel(device);
    }

    public static final /* synthetic */ boolean access$updatePermission(BaseUsbConnector $this, UsbDevice device, boolean hasPermission) {
        return $this.updatePermission(device, hasPermission);
    }

    public static final /* synthetic */ void access$processAttach(BaseUsbConnector $this, UsbDevice device) {
        $this.processAttach(device);
    }

    public static final /* synthetic */ int access$getMDeviceCounts$p(BaseUsbConnector $this) {
        return $this.mDeviceCounts;
    }

    public static final /* synthetic */ void access$setMDeviceCounts$p(BaseUsbConnector $this, int n) {
        $this.mDeviceCounts = n;
    }

    public static final /* synthetic */ void access$processDettach(BaseUsbConnector $this, UsbDevice device) {
        $this.processDettach(device);
    }

    public static final /* synthetic */ Handler access$getMAsyncHandler$p(BaseUsbConnector $this) {
        Handler handler = $this.mAsyncHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAsyncHandler");
        }
        return handler;
    }

    public static final /* synthetic */ void access$setMAsyncHandler$p(BaseUsbConnector $this, Handler handler) {
        $this.mAsyncHandler = handler;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\tJ$\u0010\u0011\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/bandyer/core_av/usb_camera/internal/BaseUsbConnector$Companion;", "", "()V", "ACTION_USB_DEVICE_ATTACHED", "", "getACTION_USB_DEVICE_ATTACHED", "()Ljava/lang/String;", "ACTION_USB_PERMISSION_BASE", "DEBUG", "", "TAG", "getDeviceKey", "", "device", "Landroid/hardware/usb/UsbDevice;", "useNewAPI", "serial", "getDeviceKeyName", "updateDeviceInfo", "Lcom/bandyer/core_av/usb_camera/UsbDeviceInfo;", "manager", "Landroid/hardware/usb/UsbManager;", "extension_usb_camera_release"})
    public static final class Companion {
        @NotNull
        public final String getACTION_USB_DEVICE_ATTACHED() {
            return ACTION_USB_DEVICE_ATTACHED;
        }

        @NotNull
        public final String getDeviceKeyName(@Nullable UsbDevice device) {
            return this.getDeviceKeyName(device, null, false);
        }

        @NotNull
        public final String getDeviceKeyName(@Nullable UsbDevice device, boolean useNewAPI) {
            return this.getDeviceKeyName(device, null, useNewAPI);
        }

        @SuppressLint(value={"NewApi"})
        @NotNull
        public final String getDeviceKeyName(@Nullable UsbDevice device, @Nullable String serial, boolean useNewAPI) {
            if (device == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(device.getVendorId());
            sb.append("#");
            sb.append(device.getProductId());
            sb.append("#");
            sb.append(device.getDeviceClass());
            sb.append("#");
            sb.append(device.getDeviceSubclass());
            sb.append("#");
            sb.append(device.getDeviceProtocol());
            if (!TextUtils.isEmpty((CharSequence)serial)) {
                sb.append("#");
                sb.append(serial);
            }
            if (useNewAPI && Build.VERSION.SDK_INT >= 21) {
                sb.append("#");
                if (TextUtils.isEmpty((CharSequence)serial)) {
                    sb.append(device.getSerialNumber());
                    sb.append("#");
                }
                sb.append(device.getManufacturerName());
                sb.append("#");
                sb.append(device.getConfigurationCount());
                sb.append("#");
                if (Build.VERSION.SDK_INT >= 23) {
                    sb.append(device.getVersion());
                    sb.append("#");
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public final int getDeviceKey(@Nullable UsbDevice device) {
            return device != null ? this.getDeviceKeyName(device, null, false).hashCode() : 0;
        }

        public final int getDeviceKey(@Nullable UsbDevice device, boolean useNewAPI) {
            return device != null ? this.getDeviceKeyName(device, null, useNewAPI).hashCode() : 0;
        }

        public final int getDeviceKey(@Nullable UsbDevice device, @Nullable String serial, boolean useNewAPI) {
            return device != null ? this.getDeviceKeyName(device, serial, useNewAPI).hashCode() : 0;
        }

        @NotNull
        public final UsbDeviceInfo updateDeviceInfo(@NotNull UsbManager manager, @NotNull UsbDevice device) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            return UsbDeviceExtensionsKt.info(device, manager);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

